/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagRepository
extends EntityRepository<Tag> {
    private static final Logger LOG = LoggerFactory.getLogger(TagRepository.class);

    public TagRepository() {
        super("/v1/tags/", "tag", Tag.class, Entity.getCollectionDAO().tagDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void prepare(Tag entity, boolean update) {
        EntityReference parentTerm = Entity.getEntityReference(entity.getParent(), Include.NON_DELETED);
        entity.setParent(parentTerm);
        EntityReference classification = Entity.getEntityReference(entity.getClassification(), Include.NON_DELETED);
        entity.setClassification(classification);
    }

    @Override
    public void storeEntity(Tag tag, boolean update) {
        EntityReference classification = tag.getClassification();
        EntityReference parent = tag.getParent();
        tag.withClassification(null).withParent(null);
        this.store(tag, update);
        tag.withClassification(classification).withParent(parent);
    }

    @Override
    public void restorePatchAttributes(Tag original, Tag updated) {
        updated.setChildren(original.getChildren());
    }

    @Override
    public void storeRelationships(Tag entity) {
        this.addClassificationRelationship(entity);
        this.addParentRelationship(entity);
    }

    @Override
    public void setFullyQualifiedName(Tag tag) {
        if (tag.getParent() == null) {
            tag.setFullyQualifiedName(FullyQualifiedName.build(tag.getClassification().getFullyQualifiedName(), tag.getName()));
        } else {
            tag.setFullyQualifiedName(FullyQualifiedName.add(tag.getParent().getFullyQualifiedName(), tag.getName()));
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Tag original, Tag updated, EntityRepository.Operation operation) {
        return new TagUpdater(original, updated, operation);
    }

    @Override
    protected void postDelete(Tag entity) {
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.CLASSIFICATION.ordinal(), entity.getFullyQualifiedName());
    }

    @Override
    public Tag setFields(Tag tag, EntityUtil.Fields fields) {
        tag.withClassification(this.getClassification(tag)).withParent(this.getParent(tag));
        if (fields.contains("usageCount")) {
            tag.withUsageCount(this.getUsageCount(tag));
        }
        return tag;
    }

    @Override
    public Tag clearFields(Tag tag, EntityUtil.Fields fields) {
        return tag.withUsageCount(fields.contains("usageCount") ? tag.getUsageCount() : null);
    }

    private Integer getUsageCount(Tag tag) {
        return tag.getUsageCount() != null ? tag.getUsageCount().intValue() : this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.CLASSIFICATION.ordinal(), tag.getFullyQualifiedName());
    }

    private EntityReference getClassification(Tag tag) {
        return this.getFromEntityRef(tag.getId(), Relationship.CONTAINS, "classification", true);
    }

    private void addClassificationRelationship(Tag term) {
        this.addRelationship(term.getClassification().getId(), term.getId(), "classification", "tag", Relationship.CONTAINS);
    }

    private void addParentRelationship(Tag term) {
        if (term.getParent() != null) {
            this.addRelationship(term.getParent().getId(), term.getId(), "tag", "tag", Relationship.CONTAINS);
        }
    }

    public class TagUpdater
    extends EntityRepository.EntityUpdater {
        public TagUpdater(Tag original, Tag updated, EntityRepository.Operation operation) {
            super((EntityRepository)TagRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("mutuallyExclusive", ((Tag)this.original).getMutuallyExclusive(), ((Tag)this.updated).getMutuallyExclusive());
            this.recordChange("disabled,", ((Tag)this.original).getDisabled(), ((Tag)this.updated).getDisabled());
            this.updateName((Tag)this.original, (Tag)this.updated);
            this.updateParent((Tag)this.original, (Tag)this.updated);
        }

        public void updateName(Tag original, Tag updated) {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), TagRepository.this.entityType));
                }
                LOG.info("Tag name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                TagRepository.this.daoCollection.tagDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                TagRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.CLASSIFICATION.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                this.recordChange("name", original.getName(), updated.getName());
            }
            this.invalidateTags(original.getId());
            TagRepository.this.getChildren(updated);
        }

        private void updateParent(Tag original, Tag updated) {
            UUID newParentId;
            UUID oldParentId = EntityUtil.getId(original.getParent());
            boolean parentChanged = !Objects.equals(oldParentId, newParentId = EntityUtil.getId(updated.getParent()));
            UUID oldCategoryId = EntityUtil.getId(original.getClassification());
            UUID newCategoryId = EntityUtil.getId(updated.getClassification());
            boolean classificationChanged = !Objects.equals(oldCategoryId, newCategoryId);
            TagRepository.this.daoCollection.tagDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            TagRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.CLASSIFICATION.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            if (classificationChanged) {
                this.updateClassificationRelationship(original, updated);
                this.recordChange("Classification", original.getClassification(), updated.getClassification(), true, EntityUtil.entityReferenceMatch);
                this.invalidateTags(original.getId());
            }
            if (parentChanged) {
                this.updateParentRelationship(original, updated);
                this.recordChange("parent", original.getParent(), updated.getParent(), true, EntityUtil.entityReferenceMatch);
                this.invalidateTags(original.getId());
            }
        }

        private void updateClassificationRelationship(Tag orig, Tag updated) {
            this.deleteClassificationRelationship(orig);
            TagRepository.this.addClassificationRelationship(updated);
        }

        private void deleteClassificationRelationship(Tag term) {
            TagRepository.this.deleteRelationship(term.getClassification().getId(), "classification", term.getId(), "tag", Relationship.CONTAINS);
        }

        private void updateParentRelationship(Tag orig, Tag updated) {
            this.deleteParentRelationship(orig);
            TagRepository.this.addParentRelationship(updated);
        }

        private void deleteParentRelationship(Tag term) {
            if (term.getParent() != null) {
                TagRepository.this.deleteRelationship(term.getParent().getId(), "tag", term.getId(), "tag", Relationship.CONTAINS);
            }
        }

        private void invalidateTags(UUID tagId) {
            List<CollectionDAO.EntityRelationshipRecord> tagRecords = TagRepository.this.findToRecords(tagId, "tag", Relationship.CONTAINS, "tag");
            EntityRepository.CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)"tag", (Object)tagId));
            for (CollectionDAO.EntityRelationshipRecord tagRecord : tagRecords) {
                this.invalidateTags(tagRecord.getId());
            }
        }
    }
}

