/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;

public class WorkflowRepository
extends EntityRepository<Workflow> {
    private static final String PATCH_FIELDS = "status,response";

    public WorkflowRepository() {
        super("/v1/automations/workflows", "workflow", Workflow.class, Entity.getCollectionDAO().workflowDAO(), PATCH_FIELDS, "");
        this.quoteFqn = true;
    }

    @Override
    public Workflow setFields(Workflow entity, EntityUtil.Fields fields) {
        return entity;
    }

    @Override
    public Workflow clearFields(Workflow entity, EntityUtil.Fields fields) {
        return entity;
    }

    @Override
    public void prepare(Workflow entity, boolean update) {
        if (entity.getRequest() == null) {
            throw new IllegalArgumentException("Request must not be empty");
        }
    }

    @Override
    public void storeEntity(Workflow entity, boolean update) {
        OpenMetadataConnection openmetadataConnection = entity.getOpenMetadataServerConnection();
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        if (secretsManager != null) {
            entity = secretsManager.encryptWorkflow(entity);
        }
        entity.withOpenMetadataServerConnection(null);
        this.store(entity, update);
        entity.withOpenMetadataServerConnection(openmetadataConnection);
    }

    @Override
    protected void postDelete(Workflow workflow) {
        SecretsManagerFactory.getSecretsManager().deleteSecretsFromWorkflow(workflow);
    }

    @Override
    public void storeRelationships(Workflow entity) {
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Workflow original, Workflow updated, EntityRepository.Operation operation) {
        return new WorkflowUpdater(original, updated, operation);
    }

    public class WorkflowUpdater
    extends EntityRepository.EntityUpdater {
        public WorkflowUpdater(Workflow original, Workflow updated, EntityRepository.Operation operation) {
            super((EntityRepository)WorkflowRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("status", ((Workflow)this.original).getStatus(), ((Workflow)this.updated).getStatus());
            this.recordChange("response", ((Workflow)this.original).getResponse(), ((Workflow)this.updated).getResponse(), true);
        }
    }
}

