/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.context;

import java.util.HashMap;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openmetadata.service.migration.api.MigrationProcess;
import org.openmetadata.service.migration.context.MigrationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationWorkflowContext {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationWorkflowContext.class);
    private HashMap<String, MigrationContext> migrationContext = new HashMap();
    private final MigrationContext initialContext;
    private final Handle handle;

    public MigrationWorkflowContext(Handle handle) {
        this.handle = handle;
        this.initialContext = new MigrationContext("initial", List.of(), handle);
    }

    public void computeInitialContext() {
        this.computeMigrationSafely(this.initialContext);
    }

    public void computeMigrationContext(MigrationProcess process) {
        MigrationContext context = new MigrationContext(process.getVersion(), process.getMigrationOps(), this.handle);
        this.computeMigrationSafely(context);
    }

    private void computeMigrationSafely(MigrationContext context) {
        try {
            context.compute();
            context.show();
            this.migrationContext.put(context.getVersion(), context);
        }
        catch (Exception e) {
            LOG.warn(String.format("Error computing context for [%s] due to [%s]", context.getVersion(), e));
        }
    }

    public HashMap<String, MigrationContext> getMigrationContext() {
        return this.migrationContext;
    }
}

