/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.V114;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.tests.CreateTestSuite;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);

    private MigrationUtil() {
    }

    public static void fixTestSuites(CollectionDAO collectionDAO) {
        TestSuiteRepository testSuiteRepository = (TestSuiteRepository)Entity.getEntityRepository("testSuite");
        List testSuites = testSuiteRepository.listAll(new EntityUtil.Fields(Set.of("id")), new ListFilter(Include.ALL));
        for (TestSuite suite : testSuites) {
            if (suite.getExecutableEntityReference() == null || suite.getExecutable().booleanValue() && suite.getFullyQualifiedName().contains("testSuite")) continue;
            String tableFQN = suite.getExecutableEntityReference().getFullyQualifiedName();
            String suiteFQN = tableFQN + ".testSuite";
            suite.setName(suiteFQN);
            suite.setFullyQualifiedName(suiteFQN);
            suite.setExecutable(Boolean.valueOf(true));
            collectionDAO.testSuiteDAO().update((EntityInterface)suite);
        }
        Map<String, ArrayList<TestCase>> testCasesGroupByTable = org.openmetadata.service.migration.utils.v110.MigrationUtil.groupTestCasesByTable();
        for (String tableFQN : testCasesGroupByTable.keySet()) {
            try {
                List testCases = testCasesGroupByTable.get(tableFQN);
                String executableTestSuiteFQN = tableFQN + ".testSuite";
                TestSuite executableTestSuite = MigrationUtil.getOrCreateExecutableTestSuite(collectionDAO, testCases, testSuiteRepository, executableTestSuiteFQN);
                for (TestCase testCase : testCases) {
                    List<CollectionDAO.EntityRelationshipRecord> existingRelations = testSuiteRepository.findFromRecords(testCase.getId(), "testCase", Relationship.CONTAINS, "testSuite");
                    boolean relationWithExecutableTestSuiteExists = false;
                    if (existingRelations != null) {
                        for (CollectionDAO.EntityRelationshipRecord existingTestSuiteRel : existingRelations) {
                            try {
                                TestSuite existingTestSuite = (TestSuite)testSuiteRepository.getDao().findEntityById(existingTestSuiteRel.getId());
                                if (!Boolean.TRUE.equals(existingTestSuite.getExecutable()) || !existingTestSuite.getFullyQualifiedName().equals(executableTestSuiteFQN)) continue;
                                relationWithExecutableTestSuiteExists = true;
                            }
                            catch (EntityNotFoundException ex) {
                                testSuiteRepository.deleteRelationship(existingTestSuiteRel.getId(), "testSuite", testCase.getId(), "testCase", Relationship.CONTAINS);
                            }
                        }
                    }
                    if (relationWithExecutableTestSuiteExists) continue;
                    testSuiteRepository.addRelationship(executableTestSuite.getId(), testCase.getId(), "testSuite", "testCase", Relationship.CONTAINS);
                }
                List<CollectionDAO.EntityRelationshipRecord> testSuiteRels = testSuiteRepository.findToRecords(executableTestSuite.getExecutableEntityReference().getId(), "table", Relationship.CONTAINS, "testSuite");
                for (CollectionDAO.EntityRelationshipRecord testSuiteRel : testSuiteRels) {
                    try {
                        testSuiteRepository.getDao().findEntityById(testSuiteRel.getId());
                    }
                    catch (EntityNotFoundException ex) {
                        testSuiteRepository.deleteRelationship(executableTestSuite.getExecutableEntityReference().getId(), "table", testSuiteRel.getId(), "testSuite", Relationship.CONTAINS);
                    }
                }
            }
            catch (Exception exc) {
                LOG.error(String.format("Error trying to migrate tests from Table [%s] due to [%s]", tableFQN, exc.getMessage()));
            }
        }
    }

    private static TestSuite getOrCreateExecutableTestSuite(CollectionDAO collectionDAO, List<TestCase> testCases, TestSuiteRepository testSuiteRepository, String executableTestSuiteFQN) {
        try {
            return (TestSuite)testSuiteRepository.getDao().findEntityByName(executableTestSuiteFQN, "fqnHash", Include.ALL);
        }
        catch (EntityNotFoundException exc) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(((TestCase)testCases.stream().findFirst().get()).getEntityLink());
            TestSuite newExecutableTestSuite = org.openmetadata.service.migration.utils.v110.MigrationUtil.getTestSuite(collectionDAO, new CreateTestSuite().withName(FullyQualifiedName.buildHash(executableTestSuiteFQN)).withDisplayName(executableTestSuiteFQN).withExecutableEntityReference(entityLink.getEntityFQN()), "ingestion-bot").withExecutable(Boolean.valueOf(true)).withFullyQualifiedName(executableTestSuiteFQN);
            testSuiteRepository.prepareInternal(newExecutableTestSuite, false);
            testSuiteRepository.getDao().insert("fqnHash", (EntityInterface)newExecutableTestSuite, newExecutableTestSuite.getFullyQualifiedName());
            testSuiteRepository.addRelationship(newExecutableTestSuite.getExecutableEntityReference().getId(), newExecutableTestSuite.getId(), "table", "testSuite", Relationship.CONTAINS);
            for (TestCase testCase : testCases) {
                testSuiteRepository.addRelationship(newExecutableTestSuite.getId(), testCase.getId(), "testSuite", "testCase", Relationship.CONTAINS);
            }
            return newExecutableTestSuite;
        }
    }
}

