/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.V117;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jdbi.v3.core.Handle;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TableRepository;
import org.openmetadata.service.jdbi3.TestCaseRepository;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;

public class MigrationUtil {
    private static final String MYSQL_LIST_TABLE_FQNS = "SELECT JSON_UNQUOTE(JSON_EXTRACT(json, '$.fullyQualifiedName')) FROM table_entity";
    private static final String POSTGRES_LIST_TABLE_FQNS = "SELECT json #>> '{fullyQualifiedName}' FROM table_entity";

    private MigrationUtil() {
    }

    public static void fixTestCases(Handle handle, CollectionDAO collectionDAO) {
        TestCaseRepository testCaseRepository = (TestCaseRepository)Entity.getEntityRepository("testCase");
        TableRepository tableRepository = (TableRepository)Entity.getEntityRepository("table");
        List testCases = testCaseRepository.listAll(new EntityUtil.Fields(Set.of("id")), new ListFilter(Include.ALL));
        List fqnList = Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL()) ? handle.createQuery(MYSQL_LIST_TABLE_FQNS).mapTo(String.class).list() : handle.createQuery(POSTGRES_LIST_TABLE_FQNS).mapTo(String.class).list();
        HashMap<String, String> tableMap = new HashMap<String, String>();
        for (String fqn : fqnList) {
            tableMap.put(fqn.toLowerCase(), fqn);
        }
        for (TestCase testCase : testCases) {
            MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(testCase.getEntityLink());
            String fqn = entityLink.getEntityFQN();
            Table table = JsonUtils.readValue(tableRepository.getDao().findJsonByFqn(fqn, Include.ALL), Table.class);
            if (table != null) continue;
            String findTableFQN = (String)tableMap.get(fqn.toLowerCase());
            MessageParser.EntityLink newEntityLink = new MessageParser.EntityLink(entityLink.getEntityType(), findTableFQN);
            testCase.setEntityLink(newEntityLink.getLinkString());
            testCase.setEntityFQN(findTableFQN);
            collectionDAO.testCaseDAO().update((EntityInterface)testCase);
        }
    }
}

