/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.bots;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.CreateBot;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.BotRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.teams.RoleResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/bots")
@Tag(name="Bots", description="A `Bot` automates tasks, such as ingesting metadata, and running data quality It performs this task as a special user in the system.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="bots", order=4)
public class BotResource
extends EntityResource<Bot, BotRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(BotResource.class);
    public static final String COLLECTION_PATH = "/v1/bots/";

    public BotResource(Authorizer authorizer) {
        super("bot", authorizer);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        List bots = ((BotRepository)this.repository).getEntitiesFromSeedData();
        String domain = SecurityUtil.getDomain(config);
        for (Bot bot : bots) {
            String userName = bot.getBotUser().getName();
            User user = UserUtil.user(userName, domain, userName).withIsBot(Boolean.valueOf(true)).withIsAdmin(Boolean.valueOf(false));
            user.setRoles(UserUtil.getRoleForBot(bot.getName()));
            user = UserUtil.addOrUpdateBotUser(user);
            bot.withBotUser(user.getEntityReference());
            ((BotRepository)this.repository).initializeEntity(bot);
        }
    }

    @Override
    public void upgrade() {
        ResultList bots = ((BotRepository)this.repository).listAfter(null, EntityUtil.Fields.EMPTY_FIELDS, new ListFilter(Include.NON_DELETED), 1000, null);
        EntityReference ingestionBotRole = RoleResource.getRole("IngestionBotRole");
        for (Bot bot : bots.getData()) {
            User botUser = (User)Entity.getEntity(bot.getBotUser(), "roles", Include.NON_DELETED);
            if (botUser.getRoles() != null) continue;
            botUser.setRoles(List.of(ingestionBotRole));
            ((BotRepository)this.repository).addRelationship(botUser.getId(), ingestionBotRole.getId(), "user", "role", Relationship.HAS);
        }
    }

    @Override
    public Bot addHref(UriInfo uriInfo, Bot entity) {
        super.addHref(uriInfo, entity);
        Entity.withHref(uriInfo, entity.getBotUser());
        return entity;
    }

    @GET
    @Operation(operationId="listBots", summary="List bots", description="Get a list of Bot.", responses={@ApiResponse(responseCode="200", description="List of Bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=BotList.class))})})
    public ResultList<Bot> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of Bot before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of Bot after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return this.listInternal(uriInfo, securityContext, "", new ListFilter(include), limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getBotByID", summary="Get a bot by Id", description="Get a bot by `Id`.", responses={@ApiResponse(responseCode="200", description="The bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Bot get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include, @Parameter(description="Id of the bot", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return (Bot)this.getInternal(uriInfo, securityContext, id, "", include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getBotByFQN", summary="Get a bot by name", description="Get a bot by `name`.", responses={@ApiResponse(responseCode="200", description="bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="404", description="Bot for instance {name} is not found")})
    public Bot getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the bot", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Bot)this.getByNameInternal(uriInfo, securityContext, EntityInterfaceUtil.quoteName((String)name), "", include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllBotVersion", summary="List bot versions", description="Get a list of all the versions of a bot identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of bot versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the bot", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="listSpecificBotVersion", summary="Get a version of the bot", description="Get a version of the bot by given `Id`", responses={@ApiResponse(responseCode="200", description="bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="404", description="Bot for instance {id} and version {version} is not found")})
    public Bot getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the bot", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="bot version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Bot)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createBot", summary="Create a bot", description="Create a new bot.", responses={@ApiResponse(responseCode="200", description="The bot ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateBot create) {
        Bot bot = this.getBot(securityContext, create);
        return this.create(uriInfo, securityContext, bot);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateBot", summary="Create or update a bot", description="Create a bot, if it does not exist. If a bot already exists, update the bot.", responses={@ApiResponse(responseCode="200", description="The bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateBot create) {
        Bot bot = this.getBot(securityContext, create);
        return this.createOrUpdate(uriInfo, securityContext, bot);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchBot", summary="Update a bot", description="Update an existing bot using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the bot", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteBot", summary="Delete a bot by Id", description="Delete a bot by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the bot", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, true, hardDelete);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteBotByFQN", summary="Delete a bot by name", description="Delete a bot by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Bot for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the bot", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, EntityInterfaceUtil.quoteName((String)name), true, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted bot", description="Restore a soft deleted bot.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Bot ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))})})
    public Response restoreBot(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private Bot getBot(CreateBot create, String user) {
        return ((BotRepository)this.repository).copy(new Bot(), (CreateEntity)create, user).withBotUser(this.getEntityReference("user", create.getBotUser())).withProvider(create.getProvider()).withFullyQualifiedName(create.getName());
    }

    private boolean userHasRelationshipWithAnyBot(User user, Bot botUser) {
        if (user == null) {
            return false;
        }
        List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(user);
        return !userBotRelationship.isEmpty() && (botUser == null || userBotRelationship.stream().anyMatch(relationship -> !relationship.getId().equals(botUser.getId())));
    }

    private List<CollectionDAO.EntityRelationshipRecord> retrieveBotRelationshipsFor(User user) {
        return ((BotRepository)this.repository).findFromRecords(user.getId(), "user", Relationship.CONTAINS, "bot");
    }

    private Bot getBot(SecurityContext securityContext, CreateBot create) {
        Bot bot = this.getBot(create, securityContext.getUserPrincipal().getName());
        Bot originalBot = this.retrieveBot(bot.getName());
        User botUser = this.retrieveUser(bot);
        if (botUser != null && !Boolean.TRUE.equals(botUser.getIsBot())) {
            throw new IllegalArgumentException(String.format("User [%s] is not a bot user", botUser.getName()));
        }
        if (this.userHasRelationshipWithAnyBot(botUser, originalBot)) {
            List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(botUser);
            bot = (Bot)((BotRepository)this.repository).get(null, ((CollectionDAO.EntityRelationshipRecord)userBotRelationship.stream().findFirst().orElseThrow()).getId(), EntityUtil.Fields.EMPTY_FIELDS);
            throw new IllegalArgumentException(CatalogExceptionMessage.userAlreadyBot(botUser.getName(), bot.getName()));
        }
        if (originalBot != null) {
            bot.setProvider(originalBot.getProvider());
        }
        return bot;
    }

    private User retrieveUser(Bot bot) {
        try {
            return (User)Entity.getEntityByName("user", bot.getBotUser().getFullyQualifiedName(), "", Include.NON_DELETED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Bot retrieveBot(String botName) {
        try {
            return (Bot)((BotRepository)this.repository).getByName(null, botName, EntityUtil.Fields.EMPTY_FIELDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class BotList
    extends ResultList<Bot> {
    }
}

