/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.pipeline;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreatePipelineService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.connections.TestConnectionResult;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.PipelineConnection;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.PipelineServiceRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/services/pipelineServices")
@Tag(name="Pipeline Services")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="pipelineServices")
public class PipelineServiceResource
extends ServiceEntityResource<PipelineService, PipelineServiceRepository, PipelineConnection> {
    public static final String COLLECTION_PATH = "v1/services/pipelineServices/";
    static final String FIELDS = "pipelines,owner,domain";

    @Override
    public PipelineService addHref(UriInfo uriInfo, PipelineService service) {
        super.addHref(uriInfo, service);
        Entity.withHref(uriInfo, service.getPipelines());
        return service;
    }

    public PipelineServiceResource(Authorizer authorizer) {
        super("pipelineService", authorizer, ServiceType.PIPELINE);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("pipelines", MetadataOperation.VIEW_BASIC);
        return null;
    }

    @GET
    @Operation(operationId="listPipelineService", summary="List pipeline services", description="Get a list of pipeline services. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of pipeline services", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineServiceList.class))})})
    public ResultList<PipelineService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter services by domain", schema=@Schema(type="string", example="Marketing")) @QueryParam(value="domain") String domain, @Parameter(description="Limit number services returned. (1 to 1000000, default 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return this.listInternal(uriInfo, securityContext, fieldsParam, include, domain, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getPipelineServiceByID", summary="Get a pipeline service by Id", description="Get a pipeline service by `Id`.", responses={@ApiResponse(responseCode="200", description="Pipeline service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineService.class))}), @ApiResponse(responseCode="404", description="Pipeline service for instance {id} is not found")})
    public PipelineService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        PipelineService pipelineService = (PipelineService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, pipelineService);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getPipelineServiceByFQN", summary="Get pipeline service by fully qualified name", description="Get a pipeline service by the service `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="Pipeline service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineService.class))}), @ApiResponse(responseCode="404", description="Pipeline service for instance {fqn} is not found")})
    public PipelineService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the pipeline service", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        PipelineService pipelineService = (PipelineService)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
        return this.decryptOrNullify(securityContext, pipelineService);
    }

    @PUT
    @Path(value="/{id}/testConnectionResult")
    @Operation(operationId="addTestConnectionResult", summary="Add test connection result", description="Add test connection result to the service.", responses={@ApiResponse(responseCode="200", description="Successfully updated the service", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))})})
    public PipelineService addTestConnectionResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TestConnectionResult testConnectionResult) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        PipelineService service = (PipelineService)((PipelineServiceRepository)this.repository).addTestConnectionResult(id, testConnectionResult);
        return this.decryptOrNullify(securityContext, service);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllPipelineServiceVersion", summary="List pipeline service versions", description="Get a list of all the versions of a pipeline service identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of pipeline service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                PipelineService pipelineService = JsonUtils.readValue((String)json, PipelineService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, pipelineService));
            }
            catch (Exception e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificPipelineService", summary="Get a version of the pipeline service", description="Get a version of the pipeline service by given `Id`", responses={@ApiResponse(responseCode="200", description="pipeline service", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineService.class))}), @ApiResponse(responseCode="404", description="Pipeline service for instance {id} and version {version} is not found")})
    public PipelineService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="pipeline service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        PipelineService pipelineService = (PipelineService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, pipelineService);
    }

    @Override
    @POST
    @Operation(operationId="createPipelineService", summary="Create a pipeline service", description="Create a new pipeline service.", responses={@ApiResponse(responseCode="200", description="Pipeline service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePipelineService create) {
        PipelineService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (PipelineService)response.getEntity());
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdatePipelineService", summary="Update pipeline service", description="Create a new pipeline service or update an existing pipeline service identified by `id`.", responses={@ApiResponse(responseCode="200", description="Pipeline service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePipelineService update) {
        PipelineService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, this.unmask(service));
        this.decryptOrNullify(securityContext, (PipelineService)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchPipelineService", summary="Update a pipeline service", description="Update an existing pipeline service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the pipeline service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deletePipelineService", summary="Delete a pipeline service by Id", description="Delete a pipeline services. If pipelines (and tasks) belong to the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Pipeline service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the pipeline service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deletePipelineServiceByName", summary="Delete a pipeline service by fully qualified name", description="Delete a pipeline services by `fullyQualifiedName`. If pipelines (and tasks) belong to the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Pipeline service for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the pipeline service", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted pipeline service.", description="Restore a soft deleted pipeline service.", responses={@ApiResponse(responseCode="200", description="Successfully restored the PipelineService ", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineService.class))})})
    public Response restorePipelineService(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private PipelineService getService(CreatePipelineService create, String user) {
        return ((PipelineServiceRepository)this.repository).copy(new PipelineService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected PipelineService nullifyConnection(PipelineService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(PipelineService service) {
        return service.getServiceType().value();
    }

    public static class PipelineServiceList
    extends ResultList<PipelineService> {
    }
}

