/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class DataProductIndex
implements SearchIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final DataProduct dataProduct;

    public DataProductIndex(DataProduct dataProduct) {
        this.dataProduct = dataProduct;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.dataProduct);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dataProduct.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dataProduct.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.dataProduct.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("entityType", "dataProduct");
        if (this.dataProduct.getOwner() != null) {
            doc.put("owner", this.getOwnerWithDisplayName(this.dataProduct.getOwner()));
        }
        if (this.dataProduct.getDomain() != null) {
            doc.put("domain", this.getDomainWithDisplayName(this.dataProduct.getDomain()));
        }
        return doc;
    }

    public static Map<String, Float> getFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(15.0f));
        fields.put("displayName.ngram", Float.valueOf(1.0f));
        fields.put("name", Float.valueOf(15.0f));
        fields.put("name.ngram", Float.valueOf(1.0f));
        fields.put("displayName.keyword", Float.valueOf(25.0f));
        fields.put("name.keyword", Float.valueOf(25.0f));
        fields.put("fqnParts.keyword", Float.valueOf(10.0f));
        fields.put("description", Float.valueOf(1.0f));
        return fields;
    }
}

