/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class DatabaseIndex
implements SearchIndex {
    final Database database;
    private static final List<String> excludeFields = List.of("changeDescription");

    public DatabaseIndex(Database database) {
        this.database = database;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.database);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.database.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.database.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.database.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "database");
        if (this.database.getOwner() != null) {
            doc.put("owner", this.getOwnerWithDisplayName(this.database.getOwner()));
        }
        if (this.database.getDomain() != null) {
            doc.put("domain", this.getDomainWithDisplayName(this.database.getDomain()));
        }
        return doc;
    }
}

