/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface SearchIndex {
    public Map<String, Object> buildESDoc();

    default public Set<String> getFQNParts(String fqn, List<String> fqnSplits) {
        HashSet<String> fqnParts = new HashSet<String>();
        fqnParts.add(fqn);
        String parent = FullyQualifiedName.getParentFQN(fqn);
        while (parent != null) {
            fqnParts.add(parent);
            parent = FullyQualifiedName.getParentFQN(parent);
        }
        fqnParts.addAll(fqnSplits);
        return fqnParts;
    }

    default public EntityReference getOwnerWithDisplayName(EntityReference owner) {
        EntityReference cloneOwner;
        cloneOwner.setDisplayName(CommonUtil.nullOrEmpty((String)(cloneOwner = JsonUtils.deepCopy(owner, EntityReference.class)).getDisplayName()) ? cloneOwner.getName() : cloneOwner.getDisplayName());
        return cloneOwner;
    }

    default public EntityReference getDomainWithDisplayName(EntityReference domain) {
        EntityReference cloneDomain;
        cloneDomain.setDisplayName(CommonUtil.nullOrEmpty((String)(cloneDomain = JsonUtils.deepCopy(domain, EntityReference.class)).getDisplayName()) ? cloneDomain.getName() : cloneDomain.getDisplayName());
        return cloneDomain;
    }
}

