/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class StorageServiceIndex
implements SearchIndex {
    final StorageService storageService;
    private static final List<String> excludeFields = List.of("changeDescription");

    public StorageServiceIndex(StorageService storageService) {
        this.storageService = storageService;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.storageService);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.storageService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.storageService.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.storageService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "metadataService");
        if (this.storageService.getOwner() != null) {
            doc.put("owner", this.getOwnerWithDisplayName(this.storageService.getOwner()));
        }
        return doc;
    }
}

