/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class TagIndex
implements SearchIndex {
    final Tag tag;
    private static final List<String> excludeFields = List.of("changeDescription");

    public TagIndex(Tag tag) {
        this.tag = tag;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.tag);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.tag.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.tag.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.tag.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        if (this.tag.getDisabled() != null && this.tag.getDisabled().booleanValue()) {
            doc.put("disabled", this.tag.getDisabled());
        } else {
            doc.put("disabled", "false");
        }
        doc.put("suggest", suggest);
        doc.put("entityType", "tag");
        return doc;
    }

    public static Map<String, Float> getFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("name", Float.valueOf(10.0f));
        fields.put("displayName", Float.valueOf(10.0f));
        fields.put("name.ngram", Float.valueOf(1.0f));
        fields.put("classification.name", Float.valueOf(1.0f));
        fields.put("description", Float.valueOf(3.0f));
        fields.put("fqnParts.keyword", Float.valueOf(10.0f));
        return fields;
    }
}

