/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=IndexMappingBuilder.class)
public class IndexMapping {
    String indexName;
    String indexMappingFile;
    String alias;
    List<String> parentAliases;

    IndexMapping(String indexName, String indexMappingFile, String alias, List<String> parentAliases) {
        this.indexName = indexName;
        this.indexMappingFile = indexMappingFile;
        this.alias = alias;
        this.parentAliases = parentAliases;
    }

    public static IndexMappingBuilder builder() {
        return new IndexMappingBuilder();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexMappingFile() {
        return this.indexMappingFile;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<String> getParentAliases() {
        return this.parentAliases;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class IndexMappingBuilder {
        private String indexName;
        private String indexMappingFile;
        private String alias;
        private List<String> parentAliases;

        IndexMappingBuilder() {
        }

        public IndexMappingBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public IndexMappingBuilder indexMappingFile(String indexMappingFile) {
            this.indexMappingFile = indexMappingFile;
            return this;
        }

        public IndexMappingBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public IndexMappingBuilder parentAliases(List<String> parentAliases) {
            this.parentAliases = parentAliases;
            return this;
        }

        public IndexMapping build() {
            return new IndexMapping(this.indexName, this.indexMappingFile, this.alias, this.parentAliases);
        }

        public String toString() {
            return "IndexMapping.IndexMappingBuilder(indexName=" + this.indexName + ", indexMappingFile=" + this.indexMappingFile + ", alias=" + this.alias + ", parentAliases=" + this.parentAliases + ")";
        }
    }
}

