/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.opensearch;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.ProcessorException;
import org.openmetadata.service.search.SearchIndexFactory;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import os.org.opensearch.action.bulk.BulkRequest;
import os.org.opensearch.action.update.UpdateRequest;
import os.org.opensearch.common.xcontent.XContentType;

public class OpenSearchEntitiesProcessor
implements Processor<BulkRequest, ResultList<? extends EntityInterface>> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchEntitiesProcessor.class);
    private final StepStats stats = new StepStats();

    @Override
    public BulkRequest process(ResultList<? extends EntityInterface> input, Map<String, Object> contextData) throws ProcessorException {
        BulkRequest requests;
        String entityType = (String)contextData.get("entityType");
        if (CommonUtil.nullOrEmpty((String)entityType)) {
            throw new IllegalArgumentException("[EsEntitiesProcessor] entityType cannot be null or empty.");
        }
        LOG.debug("[EsEntitiesProcessor] Processing a Batch of Size: {}, EntityType: {} ", (Object)input.getData().size(), (Object)entityType);
        try {
            requests = this.buildBulkRequests(entityType, input.getData());
            LOG.debug("[EsEntitiesProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.getData().size(), input.getData().size(), 0});
            this.updateStats(input.getData().size(), 0);
        }
        catch (Exception e) {
            LOG.debug("[EsEntitiesProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.getData().size(), 0, input.getData().size()});
            this.updateStats(0, input.getData().size());
            throw new ProcessorException("[EsEntitiesProcessor] Batch encountered Exception. Failing Completely.", e);
        }
        return requests;
    }

    private BulkRequest buildBulkRequests(String entityType, List<? extends EntityInterface> entities) {
        BulkRequest bulkRequests = new BulkRequest();
        for (EntityInterface entityInterface : entities) {
            UpdateRequest request = OpenSearchEntitiesProcessor.getUpdateRequest(entityType, entityInterface);
            bulkRequests.add(request);
        }
        return bulkRequests;
    }

    public static UpdateRequest getUpdateRequest(String entityType, EntityInterface entity) {
        IndexMapping indexMapping = Entity.getSearchRepository().getIndexMapping(entityType);
        UpdateRequest updateRequest = new UpdateRequest(indexMapping.getIndexName(), entity.getId().toString());
        updateRequest.doc(JsonUtils.pojoToJson(Objects.requireNonNull(SearchIndexFactory.buildIndex(entityType, entity)).buildESDoc()), XContentType.JSON);
        updateRequest.docAsUpsert(true);
        return updateRequest;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

