/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SecretsUtil {
    private SecretsUtil() {
    }

    public static String buildExceptionMessageUnrecognizedField(String message, String defaultMessage, String exceptionMessage, String type) {
        if (exceptionMessage != null && exceptionMessage.contains("Unrecognized field")) {
            Pattern pattern = Pattern.compile("Unrecognized field \"(.*?)\"");
            Matcher matcher = pattern.matcher(exceptionMessage);
            if (matcher.find()) {
                String fieldValue = matcher.group(1);
                return String.format(message, type, fieldValue);
            }
            return String.format(defaultMessage, type);
        }
        return null;
    }

    public static String buildExceptionMessageConnection(String exceptionMessage, String type, String firstAction, String secondAction, boolean isFirstAction) {
        return SecretsUtil.buildExceptionMessageUnrecognizedField("Failed to " + (isFirstAction ? firstAction : secondAction) + " '%s' connection stored in DB due to an unrecognized field: '%s'", "Failed to " + (isFirstAction ? firstAction : secondAction) + " '%s' connection stored in DB due to malformed connection object.", exceptionMessage, type);
    }

    public static String buildExceptionMessageConnection(String exceptionMessage, String type, boolean encrypt) {
        return SecretsUtil.buildExceptionMessageConnection(exceptionMessage, type, "encrypt", "decrypt", encrypt);
    }

    public static String buildExceptionMessageConnectionMask(String exceptionMessage, String type, boolean mask) {
        return SecretsUtil.buildExceptionMessageConnection(exceptionMessage, type, "mask", "unmask", mask);
    }
}

