/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import com.cronutils.mapper.CronMapper;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.List;
import org.openmetadata.schema.AppRuntime;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.services.ingestionPipelines.CreateIngestionPipeline;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.app.AppType;
import org.openmetadata.schema.entity.app.ExternalAppIngestionConfig;
import org.openmetadata.schema.entity.app.ScheduleType;
import org.openmetadata.schema.entity.app.ScheduledExecutionContext;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.NativeApplication;
import org.openmetadata.service.apps.scheduler.AppScheduler;
import org.openmetadata.service.apps.scheduler.OmAppJobListener;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNativeApplication
implements NativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNativeApplication.class);
    protected CollectionDAO collectionDAO;
    private App app;
    protected SearchRepository searchRepository;
    private final CronMapper cronMapper = CronMapper.fromQuartzToUnix();
    private final CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));

    @Override
    public void init(App app, CollectionDAO dao, SearchRepository searchRepository) {
        this.collectionDAO = dao;
        this.searchRepository = searchRepository;
        this.app = app;
    }

    @Override
    public void triggerOnDemand() {
        if (!this.app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            throw new IllegalArgumentException("Live Application cannot scheduled.");
        }
        AppRuntime runtime = AbstractNativeApplication.getAppRuntime(this.app);
        this.validateServerExecutableApp(runtime);
        AppScheduler.getInstance().triggerOnDemandApplication(this.app);
    }

    @Override
    public void scheduleInternal() {
        if (this.app.getAppType() == AppType.Internal && this.app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            AppRuntime runtime = (AppRuntime)JsonUtils.convertValue(this.app.getRuntime(), ScheduledExecutionContext.class);
            this.validateServerExecutableApp(runtime);
            AppScheduler.getInstance().addApplicationSchedule(this.app);
            return;
        }
        throw new IllegalArgumentException("Application Type is not valid.");
    }

    @Override
    public void initializeExternalApp() {
        if (this.app.getAppType() == AppType.External && this.app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            ExternalAppIngestionConfig ingestionConfig = JsonUtils.convertValue(this.app.getAppConfiguration(), ExternalAppIngestionConfig.class);
            try {
                String fqn = FullyQualifiedName.add(ingestionConfig.getService().getName(), ingestionConfig.getName());
                IngestionPipeline storedPipeline = (IngestionPipeline)ingestionPipelineRepository.getByName(null, fqn, ingestionPipelineRepository.getFields("id"));
                List<CollectionDAO.EntityRelationshipRecord> records = this.collectionDAO.relationshipDAO().findTo(this.app.getId(), "app", Relationship.HAS.ordinal(), "ingestionPipeline");
                if (records.isEmpty()) {
                    this.collectionDAO.relationshipDAO().insert(this.app.getId(), storedPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
                }
            }
            catch (EntityNotFoundException ex) {
                EntityRepository<? extends EntityInterface> serviceRepository = Entity.getServiceEntityRepository(ServiceType.fromValue((String)ingestionConfig.getService().getType()));
                EntityReference service = serviceRepository.getByName(null, ingestionConfig.getService().getName(), serviceRepository.getFields("id")).getEntityReference();
                Cron quartzCron = this.cronParser.parse(this.app.getAppSchedule().getCronExpression());
                CreateIngestionPipeline createPipelineRequest = new CreateIngestionPipeline().withName(ingestionConfig.getName()).withDisplayName(ingestionConfig.getDisplayName()).withDescription(ingestionConfig.getDescription()).withPipelineType(ingestionConfig.getPipelineType()).withSourceConfig(ingestionConfig.getSourceConfig()).withAirflowConfig(ingestionConfig.getAirflowConfig().withScheduleInterval(this.cronMapper.map(quartzCron).asString())).withService(service);
                IngestionPipeline dataInsightPipeline = this.getIngestionPipeline(createPipelineRequest, String.format("%sBot", this.app.getName()), "admin").withProvider(ProviderType.USER);
                ingestionPipelineRepository.setFullyQualifiedName(dataInsightPipeline);
                ingestionPipelineRepository.initializeEntity(dataInsightPipeline);
                this.collectionDAO.relationshipDAO().insert(this.app.getId(), dataInsightPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
            }
        } else {
            throw new IllegalArgumentException("Application Type is not valid.");
        }
    }

    protected void validateServerExecutableApp(AppRuntime context) {
        if (!this.app.getAppType().equals((Object)AppType.Internal)) {
            throw new IllegalArgumentException("Application cannot be executed internally in Server. Please check if the App supports internal Server Execution.");
        }
        if (context == null || !Boolean.TRUE.equals(context.getEnabled())) {
            throw new IllegalArgumentException("Applications does not support on demand execution or the context is not Internal.");
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        App jobApp = (App)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"applicationInfoKey");
        CollectionDAO dao = (CollectionDAO)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"daoKey");
        SearchRepository searchRepositoryForJob = (SearchRepository)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"searchClientKey");
        this.init(jobApp, dao, searchRepositoryForJob);
        this.startApp(jobExecutionContext);
    }

    public static AppRuntime getAppRuntime(App app) {
        return (AppRuntime)JsonUtils.convertValue(app.getRuntime(), ScheduledExecutionContext.class);
    }

    protected IngestionPipeline getIngestionPipeline(CreateIngestionPipeline create, String botname, String user) {
        IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(ingestionPipelineRepository.getOpenMetadataApplicationConfig(), botname).build();
        return ingestionPipelineRepository.copy(new IngestionPipeline(), (CreateEntity)create, user).withPipelineType(create.getPipelineType()).withAirflowConfig(create.getAirflowConfig()).withOpenMetadataServerConnection(openMetadataServerConnection).withSourceConfig(create.getSourceConfig()).withLoggerLevel(create.getLoggerLevel()).withService(create.getService());
    }

    private OmAppJobListener getJobListener(JobExecutionContext jobExecutionContext) throws SchedulerException {
        return (OmAppJobListener)jobExecutionContext.getScheduler().getListenerManager().getJobListener("OM_JOB_LISTENER");
    }

    protected AppRunRecord getJobRecord(JobExecutionContext jobExecutionContext) {
        OmAppJobListener listener = this.getJobListener(jobExecutionContext);
        return listener.getAppRunRecordForJob(jobExecutionContext);
    }

    protected void pushAppStausUpdates(JobExecutionContext jobExecutionContext, AppRunRecord record, boolean update) {
        OmAppJobListener listener = this.getJobListener(jobExecutionContext);
        listener.pushApplicationStatusUpdates(jobExecutionContext, record, update);
    }
}

