/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.analytics.DataAssetValues;
import org.openmetadata.schema.dataInsight.type.AggregatedUnusedAssetsCount;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class AggregatedUnusedAssetsCountAggregator<A, H, B, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    public AggregatedUnusedAssetsCountAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        H histogramBucket = this.getHistogramBucket(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B bucket : this.getBuckets(histogramBucket)) {
            String dateTimeString = this.getKeyAsString(bucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            S unusedThreeDays = this.getAggregations(bucket, "unusedDataAssetsThreeDays");
            S unusedSevenDays = this.getAggregations(bucket, "unusedDataAssetsSevenDays");
            S unusedFourteenDays = this.getAggregations(bucket, "unusedDataAssetsFourteenDays");
            S unusedThirtyDays = this.getAggregations(bucket, "unusedDataAssetsThirtyDays");
            S unusedSixtyDays = this.getAggregations(bucket, "unusedDataAssetsSixtyDays");
            S frequentlyUsedThreeDays = this.getAggregations(bucket, "frequentlyUsedDataAssetsThreeDays");
            S frequentlyUsedSevenDays = this.getAggregations(bucket, "frequentlyUsedDataAssetsSevenDays");
            S frequentlyUsedFourteenDays = this.getAggregations(bucket, "frequentlyUsedDataAssetsFourteenDays");
            S frequentlyUsedThirtyDays = this.getAggregations(bucket, "frequentlyUsedDataAssetsThirtyDays");
            S frequentlyUsedSixtyDays = this.getAggregations(bucket, "frequentlyUsedDataAssetsSixtyDays");
            data.add(new AggregatedUnusedAssetsCount().withTimestamp(timestamp).withUnusedDataAssets(new DataAssetValues().withThreeDays(this.getValue(unusedThreeDays)).withSevenDays(this.getValue(unusedSevenDays)).withFourteenDays(this.getValue(unusedFourteenDays)).withThirtyDays(this.getValue(unusedThirtyDays)).withSixtyDays(this.getValue(unusedSixtyDays))).withFrequentlyUsedDataAssets(new DataAssetValues().withThreeDays(this.getValue(frequentlyUsedThreeDays)).withSevenDays(this.getValue(frequentlyUsedSevenDays)).withFourteenDays(this.getValue(frequentlyUsedFourteenDays)).withThirtyDays(this.getValue(frequentlyUsedThirtyDays)).withSixtyDays(this.getValue(frequentlyUsedSixtyDays))));
        }
        return data;
    }

    protected abstract H getHistogramBucket(A var1);

    protected abstract List<? extends B> getBuckets(H var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract S getAggregations(B var1, String var2);

    protected abstract Double getValue(S var1);
}

