/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProductRepository
extends EntityRepository<DataProduct> {
    private static final Logger LOG = LoggerFactory.getLogger(DataProductRepository.class);
    private static final String UPDATE_FIELDS = "experts,assets";

    public DataProductRepository() {
        super("/v1/dataProducts/", "dataProduct", DataProduct.class, Entity.getCollectionDAO().dataProductDAO(), UPDATE_FIELDS, UPDATE_FIELDS);
        this.supportsSearch = true;
    }

    @Override
    public DataProduct setFields(DataProduct entity, EntityUtil.Fields fields) {
        return entity.withAssets(fields.contains("assets") ? this.getAssets(entity) : null);
    }

    @Override
    public DataProduct clearFields(DataProduct entity, EntityUtil.Fields fields) {
        return entity.withAssets(fields.contains("assets") ? entity.getAssets() : null);
    }

    private List<EntityReference> getAssets(DataProduct entity) {
        return this.findTo(entity.getId(), "dataProduct", Relationship.HAS, null);
    }

    @Override
    public void prepare(DataProduct entity, boolean update) {
    }

    @Override
    public void storeEntity(DataProduct entity, boolean update) {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(DataProduct entity) {
        this.addRelationship(entity.getDomain().getId(), entity.getId(), "domain", "dataProduct", Relationship.CONTAINS);
        for (EntityReference expert : CommonUtil.listOrEmpty((List)entity.getExperts())) {
            this.addRelationship(entity.getId(), expert.getId(), "dataProduct", "user", Relationship.EXPERT);
        }
        for (EntityReference asset : CommonUtil.listOrEmpty((List)entity.getAssets())) {
            this.addRelationship(entity.getId(), asset.getId(), "dataProduct", asset.getType(), Relationship.HAS);
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(DataProduct original, DataProduct updated, EntityRepository.Operation operation) {
        return new DataProductUpdater(original, updated, operation);
    }

    @Override
    public void restorePatchAttributes(DataProduct original, DataProduct updated) {
        updated.withDomain(original.getDomain());
    }

    @Override
    protected void postUpdate(DataProduct original, DataProduct updated) {
        super.postUpdate(original, updated);
        HashMap assetsMap = new HashMap();
        CommonUtil.listOrEmpty((List)original.getAssets()).forEach(asset -> assetsMap.put(asset.getId().toString(), asset));
        CommonUtil.listOrEmpty((List)updated.getAssets()).forEach(asset -> assetsMap.put(asset.getId().toString(), asset));
        for (EntityReference assetRef : assetsMap.values()) {
            EntityInterface asset2 = (EntityInterface)Entity.getEntity(assetRef, "*", Include.ALL);
            this.searchRepository.updateEntity(asset2);
        }
    }

    public class DataProductUpdater
    extends EntityRepository.EntityUpdater {
        public DataProductUpdater(DataProduct original, DataProduct updated, EntityRepository.Operation operation) {
            super((EntityRepository)DataProductRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updateAssets();
        }

        private void updateAssets() {
            ArrayList deleted;
            ArrayList added;
            List updatedToRefs;
            List origToRefs = CommonUtil.listOrEmpty((List)((DataProduct)this.original).getAssets());
            if (!this.recordListChange("assets", origToRefs, updatedToRefs = CommonUtil.listOrEmpty((List)((DataProduct)this.updated).getAssets()), added = new ArrayList(), deleted = new ArrayList(), EntityUtil.entityReferenceMatch)) {
                return;
            }
            for (EntityReference asset : deleted) {
                DataProductRepository.this.deleteRelationship(((DataProduct)this.original).getId(), "dataProduct", asset.getId(), asset.getType(), Relationship.HAS);
            }
            for (EntityReference asset : added) {
                DataProductRepository.this.addRelationship(((DataProduct)this.original).getId(), asset.getId(), "dataProduct", asset.getType(), Relationship.HAS, false);
            }
            updatedToRefs.sort(EntityUtil.compareEntityReference);
            origToRefs.sort(EntityUtil.compareEntityReference);
        }
    }
}

