/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.UUID;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityTimeSeriesInterface;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.JsonUtils;

@Repository
public abstract class EntityTimeSeriesRepository<T extends EntityTimeSeriesInterface> {
    protected final String collectionPath;
    protected final EntityTimeSeriesDAO timeSeriesDao;
    protected final SearchRepository searchRepository;
    protected final String entityType;
    protected final Class<T> entityClass;
    protected final boolean supportsSearchIndex = true;

    protected EntityTimeSeriesRepository(String collectionPath, EntityTimeSeriesDAO timeSeriesDao, Class<T> entityClass, String entityType) {
        this.collectionPath = collectionPath;
        this.timeSeriesDao = timeSeriesDao;
        this.entityClass = entityClass;
        this.entityType = entityType;
        this.searchRepository = Entity.getSearchRepository();
        Entity.registerEntity(entityClass, entityType, this);
    }

    @Transaction
    public T createNewRecord(T record, String extension, String recordFQN) {
        record.setId(UUID.randomUUID());
        this.timeSeriesDao.insert(recordFQN, extension, this.entityType, JsonUtils.pojoToJson(record));
        this.postCreate(record);
        return record;
    }

    protected void postCreate(T entity) {
        this.searchRepository.createTimeSeriesEntity((EntityTimeSeriesInterface)JsonUtils.deepCopy(entity, this.entityClass));
    }

    public String getCollectionPath() {
        return this.collectionPath;
    }

    public EntityTimeSeriesDAO getTimeSeriesDao() {
        return this.timeSeriesDao;
    }

    public SearchRepository getSearchRepository() {
        return this.searchRepository;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

