/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.SearchIndex;
import org.openmetadata.schema.entity.services.SearchService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.SearchIndexField;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.searchindex.SearchIndexSampleData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.mask.PIIMasker;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class SearchIndexRepository
extends EntityRepository<SearchIndex> {
    public SearchIndexRepository() {
        super("v1/searchIndexes/", "searchIndex", SearchIndex.class, Entity.getCollectionDAO().searchIndexDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(SearchIndex searchIndex) {
        searchIndex.setFullyQualifiedName(FullyQualifiedName.add(searchIndex.getService().getFullyQualifiedName(), searchIndex.getName()));
        if (searchIndex.getFields() != null) {
            this.setFieldFQN(searchIndex.getFullyQualifiedName(), searchIndex.getFields());
        }
    }

    @Override
    public void prepare(SearchIndex searchIndex, boolean update) {
        SearchService searchService = (SearchService)Entity.getEntity(searchIndex.getService(), "", Include.ALL);
        searchIndex.setService(searchService.getEntityReference());
        searchIndex.setServiceType(searchService.getServiceType());
    }

    @Override
    public void storeEntity(SearchIndex searchIndex, boolean update) {
        EntityReference service = searchIndex.getService();
        searchIndex.withService(null);
        List fieldsWithTags = null;
        if (searchIndex.getFields() != null) {
            fieldsWithTags = searchIndex.getFields();
            searchIndex.setFields(this.cloneWithoutTags(fieldsWithTags));
            searchIndex.getFields().forEach(field -> field.setTags(null));
        }
        this.store(searchIndex, update);
        if (fieldsWithTags != null) {
            searchIndex.setFields(fieldsWithTags);
        }
        searchIndex.withService(service);
    }

    @Override
    public void storeRelationships(SearchIndex searchIndex) {
        this.setService(searchIndex, searchIndex.getService());
    }

    @Override
    public SearchIndex setInheritedFields(SearchIndex searchIndex, EntityUtil.Fields fields) {
        SearchService service = (SearchService)Entity.getEntity("searchService", searchIndex.getService().getId(), "domain", Include.ALL);
        return this.inheritDomain(searchIndex, fields, (EntityInterface)service);
    }

    @Override
    public SearchIndex setFields(SearchIndex searchIndex, EntityUtil.Fields fields) {
        searchIndex.setService(this.getContainer(searchIndex.getId()));
        searchIndex.setFollowers(fields.contains("followers") ? this.getFollowers(searchIndex) : null);
        if (searchIndex.getFields() != null) {
            this.getFieldTags(fields.contains("tags"), searchIndex.getFields());
        }
        return searchIndex;
    }

    @Override
    public SearchIndex clearFields(SearchIndex searchIndex, EntityUtil.Fields fields) {
        return searchIndex;
    }

    public SearchIndexUpdater getUpdater(SearchIndex original, SearchIndex updated, EntityRepository.Operation operation) {
        return new SearchIndexUpdater(original, updated, operation);
    }

    public void setService(SearchIndex searchIndex, EntityReference service) {
        if (service != null && searchIndex != null) {
            this.addRelationship(service.getId(), searchIndex.getId(), service.getType(), "searchIndex", Relationship.CONTAINS);
            searchIndex.setService(service);
        }
    }

    public SearchIndex getSampleData(UUID searchIndexId, boolean authorizePII) {
        SearchIndex searchIndex = (SearchIndex)this.dao.findEntityById(searchIndexId);
        SearchIndexSampleData sampleData = JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(searchIndex.getId(), "searchIndex.sampleData"), SearchIndexSampleData.class);
        searchIndex.setSampleData(sampleData);
        this.setFieldsInternal(searchIndex, EntityUtil.Fields.EMPTY_FIELDS);
        if (!authorizePII) {
            this.getFieldTags(true, searchIndex.getFields());
            searchIndex.setTags(this.getTags(searchIndex.getFullyQualifiedName()));
            return PIIMasker.getSampleData(searchIndex);
        }
        return searchIndex;
    }

    public SearchIndex addSampleData(UUID searchIndexId, SearchIndexSampleData sampleData) {
        SearchIndex searchIndex = (SearchIndex)this.daoCollection.searchIndexDAO().findEntityById(searchIndexId);
        this.daoCollection.entityExtensionDAO().insert(searchIndexId, "searchIndex.sampleData", "searchIndexSampleData", JsonUtils.pojoToJson(sampleData));
        this.setFieldsInternal(searchIndex, EntityUtil.Fields.EMPTY_FIELDS);
        return searchIndex.withSampleData(sampleData);
    }

    private void setFieldFQN(String parentFQN, List<SearchIndexField> fields) {
        fields.forEach(c -> {
            String fieldFqn = FullyQualifiedName.add(parentFQN, c.getName());
            c.setFullyQualifiedName(fieldFqn);
            if (c.getChildren() != null) {
                this.setFieldFQN(fieldFqn, c.getChildren());
            }
        });
    }

    private void getFieldTags(boolean setTags, List<SearchIndexField> fields) {
        for (SearchIndexField f : CommonUtil.listOrEmpty(fields)) {
            f.setTags(setTags ? this.getTags(f.getFullyQualifiedName()) : null);
            this.getFieldTags(setTags, f.getChildren());
        }
    }

    private void addDerivedFieldTags(List<SearchIndexField> fields) {
        if (CommonUtil.nullOrEmpty(fields)) {
            return;
        }
        for (SearchIndexField field : fields) {
            field.setTags(this.addDerivedTags(field.getTags()));
            if (field.getChildren() == null) continue;
            this.addDerivedFieldTags(field.getChildren());
        }
    }

    List<SearchIndexField> cloneWithoutTags(List<SearchIndexField> fields) {
        if (CommonUtil.nullOrEmpty(fields)) {
            return fields;
        }
        ArrayList<SearchIndexField> copy = new ArrayList<SearchIndexField>();
        fields.forEach(f -> copy.add(this.cloneWithoutTags((SearchIndexField)f)));
        return copy;
    }

    private SearchIndexField cloneWithoutTags(SearchIndexField field) {
        List<SearchIndexField> children = this.cloneWithoutTags(field.getChildren());
        return new SearchIndexField().withDescription(field.getDescription()).withName(field.getName()).withDisplayName(field.getDisplayName()).withFullyQualifiedName(field.getFullyQualifiedName()).withDataType(field.getDataType()).withDataTypeDisplay(field.getDataTypeDisplay()).withChildren(children);
    }

    @Override
    public void validateTags(SearchIndex entity) {
        super.validateTags(entity);
        this.validateSchemaFieldTags(entity.getFields());
    }

    private void validateSchemaFieldTags(List<SearchIndexField> fields) {
        for (SearchIndexField field : CommonUtil.listOrEmpty(fields)) {
            this.validateTags(field.getTags());
            field.setTags(this.addDerivedTags(field.getTags()));
            this.checkMutuallyExclusive(field.getTags());
            if (field.getChildren() == null) continue;
            this.validateSchemaFieldTags(field.getChildren());
        }
    }

    private void applyFieldTags(List<SearchIndexField> fields) {
        for (SearchIndexField field : fields) {
            this.applyTags(field.getTags(), field.getFullyQualifiedName());
            if (field.getChildren() == null) continue;
            this.applyFieldTags(field.getChildren());
        }
    }

    @Override
    public void applyTags(SearchIndex searchIndex) {
        super.applyTags(searchIndex);
        if (searchIndex.getFields() != null) {
            this.applyFieldTags(searchIndex.getFields());
        }
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        SearchIndex searchIndex = (SearchIndex)entity;
        EntityUtil.mergeTags(allTags, searchIndex.getTags());
        List schemaFields = searchIndex.getFields() != null ? searchIndex.getFields() : null;
        for (SearchIndexField schemaField : CommonUtil.listOrEmpty((List)schemaFields)) {
            EntityUtil.mergeTags(allTags, schemaField.getTags());
        }
        return allTags;
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals("fields")) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (EntityUtil.isDescriptionTask(taskType)) {
                return new FieldDescriptionWorkflow(threadContext);
            }
            if (EntityUtil.isTagTask(taskType)) {
                return new FieldTagWorkflow(threadContext);
            }
            throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    private static SearchIndexField getSchemaField(SearchIndex searchIndex, String fieldName) {
        String schemaName = fieldName;
        List schemaFields = searchIndex.getFields();
        String childSchemaName = "";
        if (fieldName.contains(".")) {
            String fieldNameWithoutQuotes = fieldName.substring(1, fieldName.length() - 1);
            schemaName = fieldNameWithoutQuotes.substring(0, fieldNameWithoutQuotes.indexOf("."));
            childSchemaName = fieldNameWithoutQuotes.substring(fieldNameWithoutQuotes.lastIndexOf(".") + 1);
        }
        SearchIndexField schemaField = null;
        for (SearchIndexField field : schemaFields) {
            if (!field.getName().equals(schemaName)) continue;
            schemaField = field;
            break;
        }
        if (!"".equals(childSchemaName) && schemaField != null) {
            schemaField = SearchIndexRepository.getChildSchemaField(schemaField.getChildren(), childSchemaName);
        }
        if (schemaField == null) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("schema", fieldName));
        }
        return schemaField;
    }

    private static SearchIndexField getChildSchemaField(List<SearchIndexField> fields, String childSchemaName) {
        SearchIndexField childrenSchemaField;
        block2: {
            childrenSchemaField = null;
            for (SearchIndexField field : fields) {
                if (!field.getName().equals(childSchemaName)) continue;
                childrenSchemaField = field;
                break;
            }
            if (childrenSchemaField != null) break block2;
            for (SearchIndexField field : fields) {
                if (field.getChildren() != null && (childrenSchemaField = SearchIndexRepository.getChildSchemaField(field.getChildren(), childSchemaName)) != null) break;
            }
        }
        return childrenSchemaField;
    }

    public class SearchIndexUpdater
    extends EntityRepository.EntityUpdater {
        public static final String FIELD_DATA_TYPE_DISPLAY = "dataTypeDisplay";

        public SearchIndexUpdater(SearchIndex original, SearchIndex updated, EntityRepository.Operation operation) {
            super((EntityRepository)SearchIndexRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            if (((SearchIndex)this.updated).getFields() != null) {
                this.updateSearchIndexFields("fields", ((SearchIndex)this.original).getFields() == null ? null : ((SearchIndex)this.original).getFields(), ((SearchIndex)this.updated).getFields(), EntityUtil.searchIndexFieldMatch);
            }
            this.recordChange("searchIndexSettings", ((SearchIndex)this.original).getSearchIndexSettings(), ((SearchIndex)this.updated).getSearchIndexSettings());
        }

        private void updateSearchIndexFields(String fieldName, List<SearchIndexField> origFields, List<SearchIndexField> updatedFields, BiPredicate<SearchIndexField, SearchIndexField> fieldMatch) {
            ArrayList deletedFields = new ArrayList();
            ArrayList addedFields = new ArrayList();
            this.recordListChange(fieldName, origFields, updatedFields, addedFields, deletedFields, fieldMatch);
            Map addedFieldMap = addedFields.stream().collect(Collectors.toMap(SearchIndexField::getName, Function.identity()));
            for (SearchIndexField deleted2 : deletedFields) {
                if (!addedFieldMap.containsKey(deleted2.getName())) continue;
                SearchIndexField addedField = (SearchIndexField)addedFieldMap.get(deleted2.getName());
                if (CommonUtil.nullOrEmpty((String)addedField.getDescription()) && CommonUtil.nullOrEmpty((String)deleted2.getDescription())) {
                    addedField.setDescription(deleted2.getDescription());
                }
                if (!CommonUtil.nullOrEmpty((List)addedField.getTags()) || !CommonUtil.nullOrEmpty((List)deleted2.getTags())) continue;
                addedField.setTags(deleted2.getTags());
            }
            deletedFields.forEach(deleted -> SearchIndexRepository.this.daoCollection.tagUsageDAO().deleteTagsByTarget(deleted.getFullyQualifiedName()));
            for (SearchIndexField added : addedFields) {
                SearchIndexRepository.this.applyTags(added.getTags(), added.getFullyQualifiedName());
            }
            for (SearchIndexField updated : updatedFields) {
                SearchIndexField stored = origFields.stream().filter(c -> fieldMatch.test((SearchIndexField)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateFieldDescription(stored, updated);
                this.updateFieldDataTypeDisplay(stored, updated);
                this.updateFieldDisplayName(stored, updated);
                this.updateTags(stored.getFullyQualifiedName(), EntityUtil.getFieldName(fieldName, updated.getName(), "tags"), stored.getTags(), updated.getTags());
                if (updated.getChildren() == null || stored.getChildren() == null) continue;
                String childrenFieldName = EntityUtil.getFieldName(fieldName, updated.getName());
                this.updateSearchIndexFields(childrenFieldName, stored.getChildren(), updated.getChildren(), fieldMatch);
            }
            this.majorVersionChange = this.majorVersionChange || !deletedFields.isEmpty();
        }

        private void updateFieldDescription(SearchIndexField origField, SearchIndexField updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDescription(origField.getDescription());
                return;
            }
            String field = EntityUtil.getSearchIndexField((SearchIndex)this.original, origField, "description");
            this.recordChange(field, origField.getDescription(), updatedField.getDescription());
        }

        private void updateFieldDisplayName(SearchIndexField origField, SearchIndexField updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDescription()) && this.updatedByBot()) {
                updatedField.setDisplayName(origField.getDisplayName());
                return;
            }
            String field = EntityUtil.getSearchIndexField((SearchIndex)this.original, origField, "displayName");
            this.recordChange(field, origField.getDisplayName(), updatedField.getDisplayName());
        }

        private void updateFieldDataTypeDisplay(SearchIndexField origField, SearchIndexField updatedField) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origField.getDataTypeDisplay()) && this.updatedByBot()) {
                updatedField.setDataTypeDisplay(origField.getDataTypeDisplay());
                return;
            }
            String field = EntityUtil.getSearchIndexField((SearchIndex)this.original, origField, FIELD_DATA_TYPE_DISPLAY);
            this.recordChange(field, origField.getDataTypeDisplay(), updatedField.getDataTypeDisplay());
        }
    }

    static class FieldDescriptionWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        private final SearchIndexField schemaField;

        FieldDescriptionWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            this.schemaField = SearchIndexRepository.getSchemaField((SearchIndex)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            this.schemaField.setDescription(resolveTask.getNewValue());
            return this.threadContext.getAboutEntity();
        }
    }

    static class FieldTagWorkflow
    extends EntityRepository.TagTaskWorkflow {
        private final SearchIndexField schemaField;

        FieldTagWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            this.schemaField = SearchIndexRepository.getSchemaField((SearchIndex)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            this.schemaField.setTags(tags);
            return this.threadContext.getAboutEntity();
        }
    }
}

