/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.apps;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppMarketPlaceDefinition;
import org.openmetadata.schema.entity.app.AppType;
import org.openmetadata.schema.entity.app.CreateAppMarketPlaceDefinitionReq;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.sdk.PipelineServiceClient;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.clients.pipeline.PipelineServiceClientFactory;
import org.openmetadata.service.jdbi3.AppMarketPlaceRepository;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/apps/marketplace")
@Tag(name="Apps", description="Apps marketplace holds to application available for Open-metadata")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="apps/marketplace", order=8)
public class AppMarketPlaceResource
extends EntityResource<AppMarketPlaceDefinition, AppMarketPlaceRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(AppMarketPlaceResource.class);
    public static final String COLLECTION_PATH = "/v1/apps/marketplace/";
    private PipelineServiceClient pipelineServiceClient;
    static final String FIELDS = "owner,tags";

    @Override
    public void initialize(OpenMetadataApplicationConfig config) {
        try {
            this.pipelineServiceClient = PipelineServiceClientFactory.createPipelineServiceClient(config.getPipelineServiceClientConfiguration());
            List<CreateAppMarketPlaceDefinitionReq> createAppMarketPlaceDefinitionReqs = EntityRepository.getEntitiesFromSeedData("app", String.format(".*json/data/%s/.*\\.json$", this.entityType), CreateAppMarketPlaceDefinitionReq.class);
            for (CreateAppMarketPlaceDefinitionReq definitionReq : createAppMarketPlaceDefinitionReqs) {
                AppMarketPlaceDefinition definition = this.getApplicationDefinition(definitionReq, "admin");
                ((AppMarketPlaceRepository)this.repository).setFullyQualifiedName(definition);
                ((AppMarketPlaceRepository)this.repository).createOrUpdate(null, definition);
            }
        }
        catch (Exception ex) {
            LOG.error("Failed in initializing App MarketPlace Resource", (Throwable)ex);
        }
    }

    public AppMarketPlaceResource(Authorizer authorizer) {
        super("appMarketPlaceDefinition", authorizer);
    }

    @GET
    @Operation(operationId="listApplications", summary="List application", description="Get a list of applications. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of KPIs", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppMarketPlaceDefinitionList.class))})})
    public ResultList<AppMarketPlaceDefinition> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number of installed applications returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tests before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tests after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllInstalledApplications", summary="List Installed Application versions", description="Get a list of all the versions of a application identified by `id`", responses={@ApiResponse(responseCode="200", description="List of installed application versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the app", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a app by Id", description="Get a app by `Id`.", responses={@ApiResponse(responseCode="200", description="The App", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppMarketPlaceDefinition.class))}), @ApiResponse(responseCode="404", description="App for instance {id} is not found")})
    public AppMarketPlaceDefinition get(@Context UriInfo uriInfo, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (AppMarketPlaceDefinition)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getAppByName", summary="Get a App by name", description="Get a App by `name`.", responses={@ApiResponse(responseCode="200", description="The App", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppMarketPlaceDefinition.class))}), @ApiResponse(responseCode="404", description="App for instance {name} is not found")})
    public AppMarketPlaceDefinition getByName(@Context UriInfo uriInfo, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (AppMarketPlaceDefinition)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificAppVersion", summary="Get a version of the App", description="Get a version of the App by given `id`", responses={@ApiResponse(responseCode="200", description="App", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))}), @ApiResponse(responseCode="404", description="App for instance {id} and version {version} is not found")})
    public AppMarketPlaceDefinition getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="KPI version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (AppMarketPlaceDefinition)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createApplication", summary="Create a Application", description="Create a application", responses={@ApiResponse(responseCode="200", description="The Application", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppMarketPlaceDefinition.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAppMarketPlaceDefinitionReq create) {
        AppMarketPlaceDefinition app = this.getApplicationDefinition(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, app);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchApplication", summary="Updates a App", description="Update an existing App using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patchApplication(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateApp", summary="Create Or Update App", description="Create or Update App, it it does not exist or update an existing KPI.", responses={@ApiResponse(responseCode="200", description="The updated Application Objective ", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateAppMarketPlaceDefinitionReq create) {
        AppMarketPlaceDefinition app = this.getApplicationDefinition(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, app);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteAppByName", summary="Delete a App by name", description="Delete a App by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="App for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, true, hardDelete);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteApp", summary="Delete a App by Id", description="Delete a App by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="App for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, true, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted KPI", description="Restore a soft deleted App.", responses={@ApiResponse(responseCode="200", description="Successfully restored the App. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppMarketPlaceDefinition.class))})})
    public Response restoreApp(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private AppMarketPlaceDefinition getApplicationDefinition(CreateAppMarketPlaceDefinitionReq create, String updatedBy) {
        AppMarketPlaceDefinition app = ((AppMarketPlaceRepository)this.repository).copy(new AppMarketPlaceDefinition(), (CreateEntity)create, updatedBy).withDeveloper(create.getDeveloper()).withDeveloperUrl(create.getDeveloperUrl()).withSupportEmail(create.getSupportEmail()).withPrivacyPolicyUrl(create.getPrivacyPolicyUrl()).withClassName(create.getClassName()).withAppType(create.getAppType()).withScheduleType(create.getScheduleType()).withRuntime(create.getRuntime()).withAppConfiguration(create.getAppConfiguration()).withPermission(create.getPermission()).withAppLogoUrl(create.getAppLogoUrl()).withAppScreenshots(create.getAppScreenshots()).withFeatures(create.getFeatures());
        this.validateApplication(app);
        return app;
    }

    private void validateApplication(AppMarketPlaceDefinition app) {
        if (app.getAppType().equals((Object)AppType.Internal)) {
            try {
                Class.forName(app.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new BadRequestException("Application Cannot be registered, because the classname cannot be found on the Classpath.");
            }
        } else {
            PipelineServiceClientResponse response = this.pipelineServiceClient.validateAppRegistration(app);
            if (response.getCode() != 200) {
                throw new BadRequestException(String.format("Application Cannot be registered, Error from Pipeline Service Client. Status Code : %s , Reponse : %s", response.getCode(), JsonUtils.pojoToJson(response)));
            }
        }
    }

    public static class AppMarketPlaceDefinitionList
    extends ResultList<AppMarketPlaceDefinition> {
    }
}

