/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.mlmodel;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreateMlModelService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.connections.TestConnectionResult;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.MlModelConnection;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.MlModelServiceRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/services/mlmodelServices")
@Tag(name="ML Model Services")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="mlmodelServices")
public class MlModelServiceResource
extends ServiceEntityResource<MlModelService, MlModelServiceRepository, MlModelConnection> {
    public static final String COLLECTION_PATH = "v1/services/mlmodelServices/";
    public static final String FIELDS = "pipelines,owner,tags,domain";

    @Override
    public MlModelService addHref(UriInfo uriInfo, MlModelService service) {
        super.addHref(uriInfo, service);
        Entity.withHref(uriInfo, service.getPipelines());
        return service;
    }

    public MlModelServiceResource(Authorizer authorizer) {
        super("mlmodelService", authorizer, ServiceType.ML_MODEL);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("pipelines", MetadataOperation.VIEW_BASIC);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_USAGE, MetadataOperation.EDIT_USAGE});
    }

    @GET
    @Operation(operationId="listMlModelService", summary="List ML model services", description="Get a list of mlModel services. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of mlModel services", content={@Content(mediaType="application/json", schema=@Schema(implementation=MlModelServiceList.class))})})
    public ResultList<MlModelService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter services by domain", schema=@Schema(type="string", example="Marketing")) @QueryParam(value="domain") String domain, @Parameter(description="Limit number services returned. (1 to 1000000, default 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return this.listInternal(uriInfo, securityContext, fieldsParam, include, domain, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getMlModelServiceByID", summary="Get an ML model service by Id", description="Get a mlModel service by `Id`.", responses={@ApiResponse(responseCode="200", description="MlModel service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MlModelService.class))}), @ApiResponse(responseCode="404", description="MlModel service for instance {id} is not found")})
    public MlModelService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ML Model service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        MlModelService mlModelService = (MlModelService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, mlModelService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getMlModelServiceByFQN", summary="Get an ML model service by name", description="Get a mlModel service by the service `name`.", responses={@ApiResponse(responseCode="200", description="MlModel service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MlModelService.class))}), @ApiResponse(responseCode="404", description="MlModel service for instance {name} is not found")})
    public MlModelService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the ML Model service", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        MlModelService mlModelService = (MlModelService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        return this.decryptOrNullify(securityContext, mlModelService);
    }

    @PUT
    @Path(value="/{id}/testConnectionResult")
    @Operation(operationId="addTestConnectionResult", summary="Add test connection result", description="Add test connection result to the service.", responses={@ApiResponse(responseCode="200", description="Successfully updated the service", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))})})
    public MlModelService addTestConnectionResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TestConnectionResult testConnectionResult) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        MlModelService service = (MlModelService)((MlModelServiceRepository)this.repository).addTestConnectionResult(id, testConnectionResult);
        return this.decryptOrNullify(securityContext, service);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllMlModelServiceVersion", summary="List ML model service versions", description="Get a list of all the versions of a mlModel service identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of mlModel service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ML Model service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                MlModelService mlModelService = JsonUtils.readValue((String)json, MlModelService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, mlModelService));
            }
            catch (Exception e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificMlModelService", summary="Get a version of the ML model service", description="Get a version of the mlModel service by given `Id`", responses={@ApiResponse(responseCode="200", description="mlModel service", content={@Content(mediaType="application/json", schema=@Schema(implementation=MlModelService.class))}), @ApiResponse(responseCode="404", description="MlModel service for instance {id} and version {version} is not found")})
    public MlModelService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ML Model service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="mlModel service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        MlModelService mlModelService = (MlModelService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, mlModelService);
    }

    @Override
    @POST
    @Operation(operationId="createMlModelService", summary="Create an ML model service", description="Create a new mlModel service.", responses={@ApiResponse(responseCode="200", description="MlModel service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MlModelService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateMlModelService create) {
        MlModelService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (MlModelService)response.getEntity());
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateMlModelService", summary="Update ML model service", description="Create a new mlModel service or update an existing mlModel service identified by `Id`.", responses={@ApiResponse(responseCode="200", description="MlModel service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MlModelService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateMlModelService update) {
        MlModelService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, this.unmask(service));
        this.decryptOrNullify(securityContext, (MlModelService)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchMlModelService", summary="Update an ML model service", description="Update an existing MlModelService service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the ML Model service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteMlModelService", summary="Delete an ML model service by Id", description="Delete a mlModel services. If mlModels (and tasks) belong to the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="MlModel service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the ML Model service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteMlModelServiceByName", summary="Delete an ML model service by name", description="Delete a mlModel services by `name`. If mlModels (and tasks) belong to the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="MlModel service for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the ML Model service", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted ML model service", description="Restore a soft deleted Ml model service.", responses={@ApiResponse(responseCode="200", description="Successfully restored the MlModelService ", content={@Content(mediaType="application/json", schema=@Schema(implementation=MlModelService.class))})})
    public Response restoreTable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private MlModelService getService(CreateMlModelService create, String user) {
        return ((MlModelServiceRepository)this.repository).copy(new MlModelService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected MlModelService nullifyConnection(MlModelService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(MlModelService service) {
        return service.getServiceType().value();
    }

    public static class MlModelServiceList
    extends ResultList<MlModelService> {
    }
}

