/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class DashboardIndex
implements SearchIndex {
    final Dashboard dashboard;
    final List<String> excludeFields = List.of("changeDescription");

    public DashboardIndex(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.dashboard);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> chartSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> dataModelSuggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dashboard.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dashboard.getDisplayName()).weight(10).build());
        serviceSuggest.add(SearchSuggest.builder().input(this.dashboard.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("dashboard", (EntityInterface)this.dashboard));
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getCharts())) {
            chartSuggest.add(SearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getDataModels())) {
            dataModelSuggest.add(SearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        doc.put("displayName", this.dashboard.getDisplayName() != null ? this.dashboard.getDisplayName() : this.dashboard.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.dashboard.getFollowers()));
        doc.put("tier", parseTags.getTierTag());
        doc.put("suggest", suggest);
        doc.put("chart_suggest", chartSuggest);
        doc.put("data_model_suggest", dataModelSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "dashboard");
        doc.put("serviceType", this.dashboard.getServiceType());
        doc.put("fqnParts", suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList()));
        doc.put("owner", this.getEntityWithDisplayName(this.dashboard.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.dashboard.getService()));
        doc.put("domain", this.getEntityWithDisplayName(this.dashboard.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("charts.name", Float.valueOf(2.0f));
        fields.put("charts.description", Float.valueOf(1.0f));
        return fields;
    }
}

