/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class QueryIndex
implements SearchIndex {
    final List<String> excludeTopicFields = List.of("changeDescription");
    final Query query;

    public QueryIndex(Query query) {
        this.query = query;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.query);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        if (this.query.getDisplayName() != null) {
            suggest.add(SearchSuggest.builder().input(this.query.getName()).weight(10).build());
        }
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeTopicFields);
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("query", (EntityInterface)this.query));
        doc.put("displayName", this.query.getDisplayName() != null ? this.query.getDisplayName() : "");
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.query.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("entityType", "query");
        doc.put("fqnParts", this.getFQNParts(this.query.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("query", Float.valueOf(10.0f));
        fields.put("query.ngram", Float.valueOf(1.0f));
        return fields;
    }
}

