/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface SearchIndex {
    public Map<String, Object> buildESDoc();

    default public Set<String> getFQNParts(String fqn, List<String> fqnSplits) {
        HashSet<String> fqnParts = new HashSet<String>();
        fqnParts.add(fqn);
        String parent = FullyQualifiedName.getParentFQN(fqn);
        while (parent != null) {
            fqnParts.add(parent);
            parent = FullyQualifiedName.getParentFQN(parent);
        }
        fqnParts.addAll(fqnSplits);
        return fqnParts;
    }

    default public EntityReference getEntityWithDisplayName(EntityReference entity) {
        EntityReference cloneEntity;
        if (entity == null) {
            return null;
        }
        cloneEntity.setDisplayName(CommonUtil.nullOrEmpty((String)(cloneEntity = JsonUtils.deepCopy(entity, EntityReference.class)).getDisplayName()) ? cloneEntity.getName() : cloneEntity.getDisplayName());
        return cloneEntity;
    }

    public static Map<String, Float> getDefaultFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(15.0f));
        fields.put("displayName.ngram", Float.valueOf(1.0f));
        fields.put("name", Float.valueOf(15.0f));
        fields.put("name.ngram", Float.valueOf(1.0f));
        fields.put("displayName.keyword", Float.valueOf(25.0f));
        fields.put("name.keyword", Float.valueOf(25.0f));
        fields.put("description", Float.valueOf(1.0f));
        fields.put("fqnParts.keyword", Float.valueOf(10.0f));
        return fields;
    }
}

