/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.openmetadata.schema.api.security.jwt.JWTTokenConfiguration;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.JWTTokenExpiry;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.jwt.JWKSKey;
import org.openmetadata.service.security.jwt.JWKSResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTTokenGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JWTTokenGenerator.class);
    private static final String SUBJECT_CLAIM = "sub";
    private static final String EMAIL_CLAIM = "email";
    private static final String IS_BOT_CLAIM = "isBot";
    public static final String TOKEN_TYPE = "tokenType";
    private static final JWTTokenGenerator INSTANCE = new JWTTokenGenerator();
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private String issuer;
    private String kid;

    private JWTTokenGenerator() {
    }

    public static JWTTokenGenerator getInstance() {
        return INSTANCE;
    }

    public void init(JWTTokenConfiguration jwtTokenConfiguration) {
        try {
            if (jwtTokenConfiguration.getRsaprivateKeyFilePath() != null && !jwtTokenConfiguration.getRsaprivateKeyFilePath().isEmpty() && jwtTokenConfiguration.getRsapublicKeyFilePath() != null && !jwtTokenConfiguration.getRsapublicKeyFilePath().isEmpty()) {
                byte[] privateKeyBytes = Files.readAllBytes(Paths.get(jwtTokenConfiguration.getRsaprivateKeyFilePath(), new String[0]));
                PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(privateKeyBytes);
                KeyFactory privateKF = KeyFactory.getInstance("RSA");
                this.privateKey = (RSAPrivateKey)privateKF.generatePrivate(privateSpec);
                byte[] publicKeyBytes = Files.readAllBytes(Paths.get(jwtTokenConfiguration.getRsapublicKeyFilePath(), new String[0]));
                X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKeyBytes);
                KeyFactory kf = KeyFactory.getInstance("RSA");
                this.publicKey = (RSAPublicKey)kf.generatePublic(spec);
                this.issuer = jwtTokenConfiguration.getJwtissuer();
                this.kid = jwtTokenConfiguration.getKeyId();
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to initialize JWTTokenGenerator ", (Throwable)ex);
        }
    }

    public JWTAuthMechanism generateJWTToken(User user, JWTTokenExpiry expiry) {
        return this.getJwtAuthMechanism(user.getName(), user.getEmail(), true, ServiceTokenType.BOT, JWTTokenGenerator.getExpiryDate(expiry), expiry);
    }

    public JWTAuthMechanism generateJWTToken(String userName, String email, long expiryInSeconds, boolean isBot, ServiceTokenType tokenType) {
        return this.getJwtAuthMechanism(userName, email, isBot, tokenType, this.getCustomExpiryDate(expiryInSeconds), null);
    }

    public JWTAuthMechanism getJwtAuthMechanism(String userName, String email, boolean isBot, ServiceTokenType tokenType, Date expires, JWTTokenExpiry expiry) {
        try {
            JWTAuthMechanism jwtAuthMechanism = new JWTAuthMechanism().withJWTTokenExpiry(expiry);
            Algorithm algorithm = Algorithm.RSA256(null, (RSAPrivateKey)this.privateKey);
            String token = JWT.create().withIssuer(this.issuer).withKeyId(this.kid).withClaim(SUBJECT_CLAIM, userName).withClaim(EMAIL_CLAIM, email).withClaim(IS_BOT_CLAIM, Boolean.valueOf(isBot)).withClaim(TOKEN_TYPE, tokenType.value()).withIssuedAt(new Date(System.currentTimeMillis())).withExpiresAt(expires).sign(algorithm);
            jwtAuthMechanism.setJWTToken(token);
            jwtAuthMechanism.setJWTTokenExpiresAt(expires != null ? Long.valueOf(expires.getTime()) : null);
            return jwtAuthMechanism;
        }
        catch (Exception e) {
            throw new JWTCreationException("Failed to generate JWT Token. Please check your OpenMetadata Configuration.", (Throwable)e);
        }
    }

    public static Date getExpiryDate(JWTTokenExpiry jwtTokenExpiry) {
        LocalDateTime expiryDate = switch (jwtTokenExpiry) {
            case JWTTokenExpiry.OneHour -> LocalDateTime.now().plusHours(1L);
            case JWTTokenExpiry.One -> LocalDateTime.now().plusDays(1L);
            case JWTTokenExpiry.Seven -> LocalDateTime.now().plusDays(7L);
            case JWTTokenExpiry.Thirty -> LocalDateTime.now().plusDays(30L);
            case JWTTokenExpiry.Sixty -> LocalDateTime.now().plusDays(60L);
            case JWTTokenExpiry.Ninety -> LocalDateTime.now().plusDays(90L);
            default -> null;
        };
        return expiryDate != null ? Date.from(expiryDate.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public Date getCustomExpiryDate(long seconds) {
        LocalDateTime expiryDate = LocalDateTime.now().plusSeconds(seconds);
        return Date.from(expiryDate.atZone(ZoneId.systemDefault()).toInstant());
    }

    public JWKSResponse getJWKSResponse() {
        JWKSResponse jwksResponse = new JWKSResponse();
        JWKSKey jwksKey = new JWKSKey();
        if (this.publicKey != null) {
            jwksKey.setKid(this.kid);
            jwksKey.setKty(this.publicKey.getAlgorithm());
            jwksKey.setN(Base64.getUrlEncoder().encodeToString(this.publicKey.getModulus().toByteArray()));
            jwksKey.setE(Base64.getUrlEncoder().encodeToString(this.publicKey.getPublicExponent().toByteArray()));
        }
        jwksResponse.setJwsKeys(List.of(jwksKey));
        return jwksResponse;
    }

    public Date getTokenExpiryFromJWT(String token) {
        DecodedJWT jwt;
        try {
            jwt = JWT.decode((String)token);
        }
        catch (JWTDecodeException e) {
            throw new AuthenticationException("Invalid token", e);
        }
        if (jwt.getExpiresAt() == null) {
            throw new AuthenticationException("Invalid Token, Expiry not present!");
        }
        return jwt.getExpiresAt();
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }
}

