/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.codec.binary.Hex;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.FieldInterface;
import org.openmetadata.schema.api.data.TermReference;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.SearchIndex;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.entity.type.CustomProperty;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.ContainerFileFormat;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.MlFeature;
import org.openmetadata.schema.type.MlHyperParameter;
import org.openmetadata.schema.type.SearchIndexField;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Task;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.schema.type.UsageStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EntityUtil.class);
    public static final Comparator<EntityReference> compareEntityReference = Comparator.comparing(EntityReference::getName);
    public static final Comparator<CollectionDAO.EntityVersionPair> compareVersion = Comparator.comparing(CollectionDAO.EntityVersionPair::getVersion);
    public static final Comparator<TagLabel> compareTagLabel = Comparator.comparing(TagLabel::getTagFQN);
    public static final Comparator<FieldChange> compareFieldChange = Comparator.comparing(FieldChange::getName);
    public static final Comparator<TableConstraint> compareTableConstraint = Comparator.comparing(TableConstraint::getConstraintType);
    public static final Comparator<ChangeEvent> compareChangeEvent = Comparator.comparing(ChangeEvent::getTimestamp);
    public static final Comparator<GlossaryTerm> compareGlossaryTerm = Comparator.comparing(GlossaryTerm::getName);
    public static final Comparator<CustomProperty> compareCustomProperty = Comparator.comparing(CustomProperty::getName);
    public static final BiPredicate<Object, Object> objectMatch = Object::equals;
    public static final BiPredicate<EntityReference, EntityReference> entityReferenceMatch = (ref1, ref2) -> ref1.getId().equals(ref2.getId()) && ref1.getType().equals(ref2.getType());
    public static final BiPredicate<TagLabel, TagLabel> tagLabelMatch = (tag1, tag2) -> tag1.getTagFQN().equals(tag2.getTagFQN()) && tag1.getSource().equals((Object)tag2.getSource());
    public static final BiPredicate<Task, Task> taskMatch = (task1, task2) -> task1.getName().equals(task2.getName());
    public static final BiPredicate<String, String> stringMatch = String::equals;
    public static final BiPredicate<Column, Column> columnMatch = (column1, column2) -> column1.getName().equalsIgnoreCase(column2.getName()) && column1.getDataType() == column2.getDataType() && column1.getArrayDataType() == column2.getArrayDataType();
    public static final BiPredicate<Column, Column> columnNameMatch = (column1, column2) -> column1.getName().equalsIgnoreCase(column2.getName());
    public static final BiPredicate<TableConstraint, TableConstraint> tableConstraintMatch = (constraint1, constraint2) -> constraint1.getConstraintType() == constraint2.getConstraintType() && constraint1.getColumns().equals(constraint2.getColumns()) && (constraint1.getReferredColumns() == null && constraint2.getReferredColumns() == null || constraint1.getReferredColumns().equals(constraint2.getReferredColumns()));
    public static final BiPredicate<MlFeature, MlFeature> mlFeatureMatch = MlFeature::equals;
    public static final BiPredicate<MlHyperParameter, MlHyperParameter> mlHyperParameterMatch = MlHyperParameter::equals;
    public static final BiPredicate<GlossaryTerm, GlossaryTerm> glossaryTermMatch = (filter1, filter2) -> filter1.getFullyQualifiedName().equals(filter2.getFullyQualifiedName());
    public static final BiPredicate<ContainerFileFormat, ContainerFileFormat> containerFileFormatMatch = Enum::equals;
    public static final BiPredicate<TermReference, TermReference> termReferenceMatch = (ref1, ref2) -> ref1.getName().equals(ref2.getName()) && ref1.getEndpoint().equals(ref2.getEndpoint());
    public static final BiPredicate<CustomProperty, CustomProperty> customFieldMatch = (ref1, ref2) -> ref1.getName().equals(ref2.getName()) && entityReferenceMatch.test(ref1.getPropertyType(), ref2.getPropertyType());
    public static final BiPredicate<Rule, Rule> ruleMatch = (ref1, ref2) -> ref1.getName().equals(ref2.getName());
    public static final BiPredicate<org.openmetadata.schema.type.Field, org.openmetadata.schema.type.Field> schemaFieldMatch = (field1, field2) -> field1.getName().equalsIgnoreCase(field2.getName()) && field1.getDataType() == field2.getDataType();
    public static final BiPredicate<SearchIndexField, SearchIndexField> searchIndexFieldMatch = (field1, field2) -> field1.getName().equalsIgnoreCase(field2.getName()) && field1.getDataType() == field2.getDataType();

    private EntityUtil() {
    }

    public static <T> T validate(Object id, String json, Class<T> clz) throws WebApplicationException {
        T entity = null;
        if (json != null) {
            entity = JsonUtils.readValue(json, clz);
        }
        if (entity == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(clz.getSimpleName(), id.toString()));
        }
        return entity;
    }

    public static List<EntityReference> populateEntityReferences(List<EntityReference> list) {
        if (list != null) {
            for (EntityReference ref : list) {
                EntityReference ref2 = Entity.getEntityReference(ref, Include.ALL);
                EntityUtil.copy(ref2, ref);
            }
            list.sort(compareEntityReference);
        }
        return list;
    }

    public static List<EntityReference> getEntityReferences(List<CollectionDAO.EntityRelationshipRecord> list) {
        if (CommonUtil.nullOrEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference> refs = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord ref : list) {
            refs.add(Entity.getEntityReferenceById(ref.getType(), ref.getId(), Include.ALL));
        }
        refs.sort(compareEntityReference);
        return refs;
    }

    public static List<EntityReference> populateEntityReferencesById(List<UUID> list, String entityType) {
        List<EntityReference> refs = EntityUtil.toEntityReferences(list, entityType);
        return EntityUtil.populateEntityReferences(refs);
    }

    public static EntityReference validateEntityLink(MessageParser.EntityLink entityLink) {
        String entityType = entityLink.getEntityType();
        String fqn = entityLink.getEntityFQN();
        return Entity.getEntityReferenceByName(entityType, fqn, Include.ALL);
    }

    public static UsageDetails getLatestUsage(CollectionDAO.UsageDAO usageDAO, UUID entityId) {
        LOG.debug("Getting latest usage for {}", (Object)entityId);
        UsageDetails details = usageDAO.getLatestUsage(entityId.toString());
        if (details == null) {
            LOG.debug("Usage details not found. Sending default usage");
            UsageStats stats = new UsageStats().withCount(Integer.valueOf(0)).withPercentileRank(Double.valueOf(0.0));
            details = new UsageDetails().withDailyStats(stats).withWeeklyStats(stats).withMonthlyStats(stats).withDate(RestUtil.DATE_FORMAT.format(new Date()));
        }
        return details;
    }

    public static void mergeTags(List<TagLabel> mergeTo, List<TagLabel> mergeFrom) {
        if (CommonUtil.nullOrEmpty(mergeFrom)) {
            return;
        }
        for (TagLabel fromTag : mergeFrom) {
            TagLabel tag = mergeTo.stream().filter(t -> tagLabelMatch.test((TagLabel)t, fromTag)).findAny().orElse(null);
            if (tag != null) continue;
            mergeTo.add(fromTag);
        }
    }

    public static List<String> getJsonDataResources(String path) throws IOException {
        return CommonUtil.getResources((Pattern)Pattern.compile(path));
    }

    public static <T extends EntityInterface> List<String> toFQNs(List<T> entities) {
        if (entities == null) {
            return Collections.emptyList();
        }
        ArrayList<String> entityReferences = new ArrayList<String>();
        for (EntityInterface entity : entities) {
            entityReferences.add(entity.getFullyQualifiedName());
        }
        return entityReferences;
    }

    public static List<UUID> strToIds(List<String> list) {
        return list.stream().map(UUID::fromString).collect(Collectors.toList());
    }

    public static List<EntityReference> toEntityReferences(List<UUID> ids, String entityType) {
        if (ids == null) {
            return null;
        }
        return ids.stream().map(id -> new EntityReference().withId(id).withType(entityType)).collect(Collectors.toList());
    }

    public static List<UUID> refToIds(List<EntityReference> refs) {
        if (refs == null) {
            return null;
        }
        return refs.stream().map(EntityReference::getId).collect(Collectors.toList());
    }

    public static <T> boolean isDescriptionRequired(Class<T> clz) {
        try {
            Field description = clz.getDeclaredField("description");
            return description.getAnnotation(NotNull.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static String getVersionExtension(String entityType, Double version) {
        return String.format("%s.%s", EntityUtil.getVersionExtensionPrefix(entityType), version.toString());
    }

    public static String getVersionExtensionPrefix(String entityType) {
        return String.format("%s.%s", entityType, "version");
    }

    public static Double getVersion(String extension) {
        String[] s = extension.split("\\.");
        String versionString = s[2] + "." + s[3];
        return Double.valueOf(versionString);
    }

    public static String getLocalColumnName(String tableFqn, String columnFqn) {
        return columnFqn.replace(tableFqn + ".", "");
    }

    public static String getFieldName(String ... strings) {
        return String.join((CharSequence)".", strings);
    }

    public static String getColumnField(Column column, String columnField) {
        String localColumnName = column.getName();
        return columnField == null ? FullyQualifiedName.build("columns", localColumnName) : FullyQualifiedName.build("columns", localColumnName, columnField);
    }

    public static String getSchemaField(Topic topic, org.openmetadata.schema.type.Field field, String fieldName) {
        String localFieldName = EntityUtil.getLocalColumnName(topic.getFullyQualifiedName(), field.getFullyQualifiedName());
        return fieldName == null ? FullyQualifiedName.build("schemaFields", localFieldName) : FullyQualifiedName.build("schemaFields", localFieldName, fieldName);
    }

    public static String getSearchIndexField(SearchIndex searchIndex, SearchIndexField field, String fieldName) {
        String localFieldName = EntityUtil.getLocalColumnName(searchIndex.getFullyQualifiedName(), field.getFullyQualifiedName());
        return fieldName == null ? FullyQualifiedName.build("fields", localFieldName) : FullyQualifiedName.build("fields", localFieldName, fieldName);
    }

    public static String getRuleField(Rule rule, String ruleField) {
        return ruleField == null ? FullyQualifiedName.build("rules", rule.getName()) : FullyQualifiedName.build("rules", rule.getName(), ruleField);
    }

    public static String getCustomField(CustomProperty property, String propertyFieldName) {
        return propertyFieldName == null ? FullyQualifiedName.build("customProperties", property.getName()) : FullyQualifiedName.build("customProperties", property.getName(), propertyFieldName);
    }

    public static String getExtensionField(String key) {
        return FullyQualifiedName.build("extension", key);
    }

    public static Double nextVersion(Double version) {
        return (double)Math.round((version + 0.1) * 10.0) / 10.0;
    }

    public static Double nextMajorVersion(Double version) {
        return (double)Math.round((version + 1.0) * 10.0) / 10.0;
    }

    public static EntityReference copy(EntityReference from, EntityReference to) {
        return to.withType(from.getType()).withId(from.getId()).withName(from.getName()).withDisplayName(from.getDisplayName()).withFullyQualifiedName(from.getFullyQualifiedName()).withDeleted(from.getDeleted());
    }

    public static List<TagLabel> toTagLabels(GlossaryTerm ... terms) {
        ArrayList<TagLabel> list = new ArrayList<TagLabel>();
        for (GlossaryTerm term : terms) {
            list.add(EntityUtil.toTagLabel(term));
        }
        return list;
    }

    public static List<TagLabel> toTagLabels(Tag ... tags) {
        ArrayList<TagLabel> list = new ArrayList<TagLabel>();
        for (Tag tag : tags) {
            list.add(EntityUtil.toTagLabel(tag));
        }
        return list;
    }

    public static TagLabel toTagLabel(GlossaryTerm term) {
        return new TagLabel().withName(term.getName()).withDisplayName(term.getDisplayName()).withDescription(term.getDescription()).withStyle(term.getStyle()).withTagFQN(term.getFullyQualifiedName()).withDescription(term.getDescription()).withSource(TagLabel.TagSource.GLOSSARY);
    }

    public static TagLabel toTagLabel(Tag tag) {
        return new TagLabel().withName(tag.getName()).withDisplayName(tag.getDisplayName()).withDescription(tag.getDescription()).withStyle(tag.getStyle()).withTagFQN(tag.getFullyQualifiedName()).withDescription(tag.getDescription()).withSource(TagLabel.TagSource.CLASSIFICATION);
    }

    public static String addField(String fields, String newField) {
        fields = fields == null ? "" : fields;
        return fields.isEmpty() ? newField : fields + ", " + newField;
    }

    public static void fieldAdded(ChangeDescription change, String fieldName, Object newValue) {
        change.getFieldsAdded().add(new FieldChange().withName(fieldName).withNewValue(newValue));
    }

    public static void fieldDeleted(ChangeDescription change, String fieldName, Object oldValue) {
        change.getFieldsDeleted().add(new FieldChange().withName(fieldName).withOldValue(oldValue));
    }

    public static void fieldUpdated(ChangeDescription change, String fieldName, Object oldValue, Object newValue) {
        FieldChange fieldChange = new FieldChange().withName(fieldName).withOldValue(oldValue).withNewValue(newValue);
        change.getFieldsUpdated().add(fieldChange);
    }

    public static MetadataOperation createOrUpdateOperation(ResourceContext resourceContext) {
        return resourceContext.getEntity() == null ? MetadataOperation.CREATE : MetadataOperation.EDIT_ALL;
    }

    public static UUID getId(EntityReference ref) {
        return ref == null ? null : ref.getId();
    }

    public static String getFqn(EntityReference ref) {
        return ref == null ? null : ref.getFullyQualifiedName();
    }

    public static String getFqn(EntityInterface entity) {
        return entity == null ? null : entity.getFullyQualifiedName();
    }

    public static List<String> getFqns(List<EntityReference> refs) {
        if (CommonUtil.nullOrEmpty(refs)) {
            return null;
        }
        ArrayList<String> fqns = new ArrayList<String>();
        for (EntityReference ref : refs) {
            fqns.add(EntityUtil.getFqn(ref));
        }
        return fqns;
    }

    public static EntityReference getEntityReference(EntityInterface entity) {
        return entity == null ? null : entity.getEntityReference();
    }

    public static EntityReference getEntityReference(String entityType, String fqn) {
        return fqn == null ? null : new EntityReference().withType(entityType).withFullyQualifiedName(fqn);
    }

    public static List<EntityReference> getEntityReferences(String entityType, List<String> fqns) {
        if (CommonUtil.nullOrEmpty(fqns)) {
            return null;
        }
        ArrayList<EntityReference> references = new ArrayList<EntityReference>();
        for (String fqn : fqns) {
            references.add(EntityUtil.getEntityReference(entityType, fqn));
        }
        return references;
    }

    public static Column getColumn(Table table, String columnName) {
        return table.getColumns().stream().filter(c -> c.getName().equals(columnName)).findFirst().orElse(null);
    }

    public static void sortByFQN(List<? extends EntityInterface> entities) {
        entities.sort(Comparator.comparing(EntityInterface::getFullyQualifiedName));
    }

    public static List<EntityReference> getEntityReferences(List<EntityReference> entities, Include include) {
        if (CommonUtil.nullOrEmpty(entities)) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference> refs = new ArrayList<EntityReference>();
        for (EntityReference entityReference : entities) {
            EntityReference entityRef = Entity.getEntityReference(entityReference, include);
            refs.add(entityRef);
        }
        return refs;
    }

    public static void validateProfileSample(String profileSampleType, double profileSampleValue) {
        if (profileSampleType.equals("PERCENTAGE") && (profileSampleValue < 0.0 || profileSampleValue > 100.0)) {
            throw new IllegalArgumentException("Profile sample value must be between 0 and 100");
        }
    }

    public static String hash(String input) {
        if (input != null) {
            byte[] checksum = MessageDigest.getInstance("MD5").digest(input.getBytes());
            return Hex.encodeHexString((byte[])checksum);
        }
        return null;
    }

    public static boolean isDescriptionTask(TaskType taskType) {
        return taskType == TaskType.RequestDescription || taskType == TaskType.UpdateDescription;
    }

    public static boolean isTagTask(TaskType taskType) {
        return taskType == TaskType.RequestTag || taskType == TaskType.UpdateTag;
    }

    public static boolean isApprovalTask(TaskType taskType) {
        return taskType == TaskType.RequestApproval;
    }

    public static Column findColumn(List<Column> columns, String columnName) {
        return columns.stream().filter(c -> c.getName().equals(columnName)).findFirst().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("column", columnName)));
    }

    public static <T extends FieldInterface> List<T> getFlattenedEntityField(List<T> fields) {
        ArrayList flattenedFields = new ArrayList();
        fields.forEach(column -> EntityUtil.flattenEntityField(column, flattenedFields));
        return flattenedFields;
    }

    private static <T extends FieldInterface> void flattenEntityField(T field, List<T> flattenedFields) {
        flattenedFields.add(field);
        List children = field.getChildren();
        for (FieldInterface child : CommonUtil.listOrEmpty((List)children)) {
            EntityUtil.flattenEntityField(child, flattenedFields);
        }
    }

    public static class Fields {
        public static final Fields EMPTY_FIELDS = new Fields(Collections.emptySet());
        private final Set<String> fieldList;

        public Fields(Set<String> fieldList) {
            this.fieldList = fieldList;
        }

        public Fields(Set<String> allowedFields, String fieldsParam) {
            if (CommonUtil.nullOrEmpty((String)fieldsParam)) {
                this.fieldList = new HashSet<String>();
                return;
            }
            this.fieldList = new HashSet<String>(Arrays.asList(fieldsParam.replace(" ", "").split(",")));
            for (String field : this.fieldList) {
                if (allowedFields.contains(field)) continue;
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidField(field));
            }
        }

        public Fields(Set<String> allowedFields, Set<String> fieldsParam) {
            if (CommonUtil.nullOrEmpty(fieldsParam)) {
                this.fieldList = new HashSet<String>();
                return;
            }
            for (String field : fieldsParam) {
                if (allowedFields.contains(field)) continue;
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidField(field));
            }
            this.fieldList = new HashSet<String>(fieldsParam);
        }

        public void addField(Set<String> allowedFields, String field) {
            if (!allowedFields.contains(field)) {
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidField(field));
            }
            this.fieldList.add(field);
        }

        public String toString() {
            return this.fieldList.toString();
        }

        public boolean contains(String field) {
            return this.fieldList.contains(field);
        }

        public Set<String> getFieldList() {
            return this.fieldList;
        }
    }
}

