/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.apps.AppPrivateConfig;
import org.openmetadata.schema.api.configuration.apps.AppsPrivateConfiguration;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.apps.AppException;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHandler.class);
    private static ApplicationHandler instance;
    private final OpenMetadataApplicationConfig config;
    private final AppsPrivateConfiguration privateConfiguration;

    private ApplicationHandler(OpenMetadataApplicationConfig config) {
        this.config = config;
        this.privateConfiguration = config.getAppsPrivateConfiguration();
    }

    public static void initialize(OpenMetadataApplicationConfig config) {
        if (instance != null) {
            return;
        }
        instance = new ApplicationHandler(config);
    }

    private void setAppRuntimeProperties(App app) {
        app.setOpenMetadataServerConnection(new OpenMetadataConnectionBuilder(this.config, app.getBot().getName()).build());
        if (this.privateConfiguration != null && !CommonUtil.nullOrEmpty((List)this.privateConfiguration.getAppsPrivateConfiguration())) {
            for (AppPrivateConfig appPrivateConfig : this.privateConfiguration.getAppsPrivateConfiguration()) {
                if (!app.getName().equals(appPrivateConfig.getName())) continue;
                app.setPreview(appPrivateConfig.getPreview());
                app.setPrivateConfiguration((Object)appPrivateConfig.getParameters());
            }
        }
    }

    public void triggerApplicationOnDemand(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        this.runMethodFromApplication(app, daoCollection, searchRepository, "triggerOnDemand");
    }

    public void installApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        this.runMethodFromApplication(app, daoCollection, searchRepository, "install");
    }

    public void configureApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        this.runMethodFromApplication(app, daoCollection, searchRepository, "configure");
    }

    public Object runAppInit(App app, CollectionDAO daoCollection, SearchRepository searchRepository) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.setAppRuntimeProperties(app);
        Class<?> clz = Class.forName(app.getClassName());
        Object resource = clz.getDeclaredConstructor(CollectionDAO.class, SearchRepository.class).newInstance(daoCollection, searchRepository);
        if (Boolean.TRUE.equals(app.getPreview())) {
            Method preview = resource.getClass().getMethod("raisePreviewMessage", App.class);
            preview.invoke(resource, app);
        }
        Method initMethod = resource.getClass().getMethod("init", App.class);
        initMethod.invoke(resource, app);
        return resource;
    }

    public void runMethodFromApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository, String methodName) {
        try {
            Object resource = this.runAppInit(app, daoCollection, searchRepository);
            Method scheduleMethod = resource.getClass().getMethod(methodName, new Class[0]);
            scheduleMethod.invoke(resource, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            LOG.error("Exception encountered", (Throwable)e);
            throw new UnhandledServerException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UnhandledServerException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new AppException(e.getTargetException().getMessage());
        }
    }

    public static ApplicationHandler getInstance() {
        return instance;
    }
}

