/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent;

import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.apps.bundles.changeEvent.email.EmailPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.gchat.GChatPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.generic.GenericPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.msteams.MSTeamsPublisher;
import org.openmetadata.service.apps.bundles.changeEvent.slack.SlackEventPublisher;

public class AlertFactory {
    public static Destination<ChangeEvent> getAlert(SubscriptionDestination config) {
        return switch (config.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionDestination.SubscriptionType.SLACK -> new SlackEventPublisher(config);
            case SubscriptionDestination.SubscriptionType.MS_TEAMS -> new MSTeamsPublisher(config);
            case SubscriptionDestination.SubscriptionType.G_CHAT -> new GChatPublisher(config);
            case SubscriptionDestination.SubscriptionType.GENERIC -> new GenericPublisher(config);
            case SubscriptionDestination.SubscriptionType.EMAIL -> new EmailPublisher(config);
            case SubscriptionDestination.SubscriptionType.ACTIVITY_FEED -> throw new IllegalArgumentException("Cannot create Activity Feed as Publisher.");
        };
    }
}

