/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.scheduler;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.app.FailureContext;
import org.openmetadata.schema.entity.app.SuccessContext;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.JsonUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public abstract class AbstractOmAppJobListener
implements JobListener {
    private final CollectionDAO collectionDAO;
    private static final String SCHEDULED_APP_RUN_EXTENSION = "AppScheduleRun";
    public static final String APP_RUN_STATS = "AppRunStats";
    public static final String JOB_LISTENER_NAME = "OM_JOB_LISTENER";

    protected AbstractOmAppJobListener(CollectionDAO dao) {
        this.collectionDAO = dao;
    }

    public String getName() {
        return JOB_LISTENER_NAME;
    }

    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        AppRunRecord runRecord;
        String runType = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"triggerType");
        App jobApp = JsonUtils.readOrConvertValue(jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"applicationInfoKey"), App.class);
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        long jobStartTime = System.currentTimeMillis();
        boolean update = false;
        if (jobExecutionContext.isRecovering()) {
            runRecord = JsonUtils.readValue(this.collectionDAO.appExtensionTimeSeriesDao().getLatestAppRun(jobApp.getId()), AppRunRecord.class);
            update = true;
        } else {
            runRecord = new AppRunRecord().withAppId(jobApp.getId()).withStartTime(Long.valueOf(jobStartTime)).withTimestamp(Long.valueOf(jobStartTime)).withRunType(runType).withStatus(AppRunRecord.Status.RUNNING).withScheduleInfo(jobApp.getAppSchedule());
        }
        dataMap.put(SCHEDULED_APP_RUN_EXTENSION, JsonUtils.pojoToJson(runRecord));
        this.pushApplicationStatusUpdates(jobExecutionContext, runRecord, update);
        this.doJobToBeExecuted(jobExecutionContext);
    }

    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
    }

    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobException) {
        AppRunRecord runRecord = JsonUtils.readOrConvertValue(jobExecutionContext.getJobDetail().getJobDataMap().get((Object)SCHEDULED_APP_RUN_EXTENSION), AppRunRecord.class);
        Object jobStats = jobExecutionContext.getJobDetail().getJobDataMap().get((Object)APP_RUN_STATS);
        long endTime = System.currentTimeMillis();
        runRecord.withEndTime(Long.valueOf(endTime));
        if (jobException == null && runRecord.getStatus() != AppRunRecord.Status.FAILED && runRecord.getStatus() != AppRunRecord.Status.ACTIVE_ERROR) {
            runRecord.withStatus(AppRunRecord.Status.SUCCESS);
            SuccessContext context = new SuccessContext();
            if (runRecord.getSuccessContext() != null) {
                context = runRecord.getSuccessContext();
            }
            context.getAdditionalProperties().put("stats", JsonUtils.getMap(jobStats));
            runRecord.setSuccessContext(context);
        } else {
            runRecord.withStatus(AppRunRecord.Status.FAILED);
            FailureContext context = new FailureContext();
            if (runRecord.getFailureContext() != null) {
                context = runRecord.getFailureContext();
            }
            if (jobException != null) {
                HashMap<String, String> failure = new HashMap<String, String>();
                failure.put("message", jobException.getMessage());
                failure.put("jobStackTrace", ExceptionUtils.getStackTrace((Throwable)jobException));
                context.withAdditionalProperty("failure", failure);
            }
            runRecord.setFailureContext(context);
        }
        this.pushApplicationStatusUpdates(jobExecutionContext, runRecord, true);
        this.doJobWasExecuted(jobExecutionContext, jobException);
    }

    public AppRunRecord getAppRunRecordForJob(JobExecutionContext context) {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        return JsonUtils.readOrConvertValue(dataMap.get((Object)SCHEDULED_APP_RUN_EXTENSION), AppRunRecord.class);
    }

    public void pushApplicationStatusUpdates(JobExecutionContext context, AppRunRecord runRecord, boolean update) {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        if (dataMap.containsKey((Object)SCHEDULED_APP_RUN_EXTENSION)) {
            dataMap.put(SCHEDULED_APP_RUN_EXTENSION, JsonUtils.pojoToJson(runRecord));
            App jobApp = JsonUtils.readOrConvertValue(context.getJobDetail().getJobDataMap().get((Object)"applicationInfoKey"), App.class);
            this.updateStatus(jobApp.getId(), runRecord, update);
        }
    }

    private void updateStatus(UUID appId, AppRunRecord appRunRecord, boolean update) {
        if (update) {
            this.collectionDAO.appExtensionTimeSeriesDao().update(appId.toString(), JsonUtils.pojoToJson(appRunRecord), appRunRecord.getTimestamp());
        } else {
            this.collectionDAO.appExtensionTimeSeriesDao().insert(JsonUtils.pojoToJson(appRunRecord));
        }
    }

    protected void doJobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobException) {
    }

    protected void doJobToBeExecuted(JobExecutionContext jobExecutionContext) {
    }
}

