/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.util.ArrayList;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.email.EmailMessage;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.decorators.OutgoingMessage;
import org.openmetadata.service.util.EmailUtil;

public class EmailMessageDecorator
implements MessageDecorator<EmailMessage> {
    @Override
    public String getBold() {
        return "<b>%s</b>";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "<b>";
    }

    @Override
    public String getAddMarkerClose() {
        return "</b>";
    }

    @Override
    public String getRemoveMarker() {
        return "<s>";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "</s>";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn, String additionalParams) {
        return String.format("<a href = '%s/%s/%s%s'>%s</a>", EmailUtil.getSmtpSettings().getOpenMetadataUrl(), entityType, fqn.trim(), CommonUtil.nullOrEmpty((String)additionalParams) ? "" : String.format("/%s", additionalParams), fqn.trim());
    }

    @Override
    public EmailMessage buildEntityMessage(ChangeEvent event) {
        return this.getEmailMessage(this.createEntityMessage(event));
    }

    @Override
    public EmailMessage buildThreadMessage(ChangeEvent event) {
        return this.getEmailMessage(this.createThreadMessage(event));
    }

    public EmailMessage getEmailMessage(OutgoingMessage outgoingMessage) {
        if (!outgoingMessage.getMessages().isEmpty()) {
            EmailMessage emailMessage = new EmailMessage();
            emailMessage.setUserName(outgoingMessage.getUserName());
            emailMessage.setEntityUrl(outgoingMessage.getEntityUrl());
            emailMessage.setUpdatedBy(outgoingMessage.getUserName());
            emailMessage.setChangeMessage(new ArrayList<String>(outgoingMessage.getMessages()));
            return emailMessage;
        }
        throw new UnhandledServerException("No messages found for the event");
    }
}

