/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationRepository
extends EntityRepository<Classification> {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationRepository.class);

    public ClassificationRepository() {
        super("/v1/classifications/", "classification", Classification.class, Entity.getCollectionDAO().classificationDAO(), "", "");
        this.quoteFqn = true;
        this.supportsSearch = true;
        this.renameAllowed = true;
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Classification original, Classification updated, EntityRepository.Operation operation) {
        return new ClassificationUpdater(original, updated, operation);
    }

    @Override
    public void setFields(Classification classification, EntityUtil.Fields fields) {
        classification.withTermCount(fields.contains("termCount") ? Integer.valueOf(this.getTermCount(classification)) : null);
        classification.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(classification) : null);
    }

    @Override
    public void clearFields(Classification classification, EntityUtil.Fields fields) {
        classification.withTermCount(fields.contains("termCount") ? classification.getTermCount() : null);
        classification.withUsageCount(fields.contains("usageCount") ? classification.getUsageCount() : null);
    }

    @Override
    public void prepare(Classification entity, boolean update) {
    }

    @Override
    public void storeEntity(Classification classification, boolean update) {
        this.store(classification, update);
    }

    @Override
    public void storeRelationships(Classification entity) {
    }

    private int getTermCount(Classification classification) {
        ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("parent", classification.getFullyQualifiedName());
        return this.daoCollection.tagDAO().listCount(filter);
    }

    private Integer getUsageCount(Classification classification) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.CLASSIFICATION.ordinal(), classification.getFullyQualifiedName());
    }

    public class ClassificationUpdater
    extends EntityRepository.EntityUpdater {
        public ClassificationUpdater(Classification original, Classification updated, EntityRepository.Operation operation) {
            super((EntityRepository)ClassificationRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("mutuallyExclusive", ((Classification)this.original).getMutuallyExclusive(), ((Classification)this.updated).getMutuallyExclusive());
            this.recordChange("disabled", ((Classification)this.original).getDisabled(), ((Classification)this.updated).getDisabled());
            this.updateName((Classification)this.original, (Classification)this.updated);
        }

        public void updateName(Classification original, Classification updated) {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), ClassificationRepository.this.entityType));
                }
                LOG.info("Classification name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                ClassificationRepository.this.setFullyQualifiedName(updated);
                ClassificationRepository.this.daoCollection.tagDAO().updateFqn(original.getName(), updated.getName());
                ClassificationRepository.this.daoCollection.tagUsageDAO().updateTagPrefix(TagLabel.TagSource.CLASSIFICATION.ordinal(), original.getName(), updated.getName());
                this.recordChange("name", original.getName(), updated.getName());
                this.invalidateClassification(original.getId());
            }
        }

        private void invalidateClassification(UUID classificationId) {
            EntityRepository.CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)"classification", (Object)classificationId));
            List<CollectionDAO.EntityRelationshipRecord> tagRecords = ClassificationRepository.this.findToRecords(classificationId, "classification", Relationship.CONTAINS, "tag");
            for (CollectionDAO.EntityRelationshipRecord tagRecord : tagRecords) {
                this.invalidateTags(tagRecord.getId());
            }
        }

        private void invalidateTags(UUID tagId) {
            List<CollectionDAO.EntityRelationshipRecord> tagRecords = ClassificationRepository.this.findToRecords(tagId, "tag", Relationship.CONTAINS, "tag");
            EntityRepository.CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)"tag", (Object)tagId));
            for (CollectionDAO.EntityRelationshipRecord tagRecord : tagRecords) {
                this.invalidateTags(tagRecord.getId());
            }
        }
    }

    public static class TagLabelMapper
    implements RowMapper<TagLabel> {
        public TagLabel map(ResultSet r, StatementContext ctx) throws SQLException {
            return new TagLabel().withLabelType(TagLabel.LabelType.values()[r.getInt("labelType")]).withState(TagLabel.State.values()[r.getInt("state")]).withTagFQN(r.getString("tagFQN"));
        }
    }
}

