/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.feeds;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.CreateSuggestion;
import org.openmetadata.schema.entity.feed.Suggestion;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.SuggestionStatus;
import org.openmetadata.schema.type.SuggestionType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.sdk.exception.SuggestionException;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.SuggestionFilter;
import org.openmetadata.service.jdbi3.SuggestionRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.PostResourceContext;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.UserUtil;

@Path(value="/v1/suggestions")
@Tag(name="Suggestions", description="Suggestions API supports ability to add suggestion for descriptions or tag labels for Entities.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="suggestions")
public class SuggestionsResource {
    public static final String COLLECTION_PATH = "/v1/suggestions/";
    private final SuggestionRepository dao = Entity.getSuggestionRepository();
    private final Authorizer authorizer;
    private final String INVALID_SUGGESTION_REQUEST = "INVALID_SUGGESTION_REQUEST";

    public static void addHref(UriInfo uriInfo, List<Suggestion> suggestions) {
        if (uriInfo != null) {
            suggestions.forEach(t -> SuggestionsResource.addHref(uriInfo, t));
        }
    }

    public static Suggestion addHref(UriInfo uriInfo, Suggestion suggestion) {
        if (uriInfo != null) {
            suggestion.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, suggestion.getId()));
        }
        return suggestion;
    }

    public SuggestionsResource(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    @GET
    @Operation(operationId="listSuggestions", summary="List Suggestions", description="Get a list of suggestions, optionally filtered by `entityLink` or `entityFQN`.", responses={@ApiResponse(responseCode="200", description="List of Suggestions", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuggestionList.class))})})
    public ResultList<Suggestion> list(@Context UriInfo uriInfo, @Parameter(description="Limit the number of suggestions returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=1L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=1L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of threads before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of threads after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Filter suggestions by entityFQN", schema=@Schema(type="string")) @QueryParam(value="entityFQN") String entityFQN, @Parameter(description="Filter threads by user id or bot id. This filter requires a 'filterType' query param.", schema=@Schema(type="string")) @QueryParam(value="userId") UUID userId, @Parameter(description="Filter threads by whether they are accepted or rejected. By default status is OPEN.") @DefaultValue(value="Open") @QueryParam(value="status") String status) {
        RestUtil.validateCursors(before, after);
        SuggestionFilter filter = SuggestionFilter.builder().suggestionStatus(SuggestionStatus.valueOf((String)status)).entityFQN(entityFQN).createdBy(userId).paginationType(before != null ? SuggestionRepository.PaginationType.BEFORE : SuggestionRepository.PaginationType.AFTER).before(before).after(after).build();
        ResultList<Suggestion> suggestions = before != null ? this.dao.listBefore(filter, limitParam, before) : this.dao.listAfter(filter, limitParam, after);
        SuggestionsResource.addHref(uriInfo, suggestions.getData());
        return suggestions;
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getSuggestionByID", summary="Get a suggestion by Id", description="Get a suggestion by `Id`.", responses={@ApiResponse(responseCode="200", description="The Suggestion", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggestion.class))}), @ApiResponse(responseCode="404", description="Suggestion for instance {id} is not found")})
    public Suggestion get(@Context UriInfo uriInfo, @Parameter(description="Id of the Thread", schema=@Schema(type="string")) @PathParam(value="id") UUID id) {
        return SuggestionsResource.addHref(uriInfo, this.dao.get(id));
    }

    @PUT
    @Path(value="/{id}/accept")
    @Operation(operationId="acceptSuggestion", summary="Accept a Suggestion", description="Accept a Suggestion and apply the changes to the entity.", responses={@ApiResponse(responseCode="200", description="The suggestion.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggestion.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response acceptSuggestion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the suggestion", schema=@Schema(type="string")) @PathParam(value="id") UUID id) {
        Suggestion suggestion = this.dao.get(id);
        this.dao.checkPermissionsForAcceptOrRejectSuggestion(suggestion, SuggestionStatus.Accepted, securityContext);
        return this.dao.acceptSuggestion(uriInfo, suggestion, securityContext, this.authorizer).toResponse();
    }

    @PUT
    @Path(value="/{id}/reject")
    @Operation(operationId="rejectSuggestion", summary="Reject a Suggestion", description="Close a Suggestion without making any changes to the entity.", responses={@ApiResponse(responseCode="200", description="The Suggestion.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggestion.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response rejectSuggestion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the suggestion", schema=@Schema(type="string")) @PathParam(value="id") UUID id) {
        Suggestion suggestion = this.dao.get(id);
        this.dao.checkPermissionsForAcceptOrRejectSuggestion(suggestion, SuggestionStatus.Rejected, securityContext);
        return this.dao.rejectSuggestion(uriInfo, suggestion, securityContext.getUserPrincipal().getName()).toResponse();
    }

    @PUT
    @Path(value="accept-all")
    @Operation(operationId="acceptAllSuggestion", summary="Accept all Suggestions from a user and an Entity", description="Accept a Suggestion and apply the changes to the entity.", responses={@ApiResponse(responseCode="200", description="The suggestion.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggestion.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public RestUtil.PutResponse<List<Suggestion>> acceptAllSuggestions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="user id", schema=@Schema(type="string")) @QueryParam(value="userId") UUID userId, @Parameter(description="fullyQualifiedName of entity", schema=@Schema(type="string")) @QueryParam(value="entityFQN") String entityFQN, @Parameter(description="Suggestion type being accepted", schema=@Schema(type="string")) @QueryParam(value="suggestionType") @DefaultValue(value="SuggestDescription") SuggestionType suggestionType) {
        SuggestionFilter filter = SuggestionFilter.builder().suggestionStatus(SuggestionStatus.Open).entityFQN(entityFQN).createdBy(userId).suggestionType(suggestionType).build();
        List<Suggestion> suggestions = this.dao.listAll(filter);
        if (!CommonUtil.nullOrEmpty(suggestions)) {
            Suggestion suggestion = this.dao.get(suggestions.get(0).getId());
            this.dao.checkPermissionsForAcceptOrRejectSuggestion(suggestion, SuggestionStatus.Rejected, securityContext);
            this.dao.checkPermissionsForEditEntity(suggestion, suggestionType, securityContext, this.authorizer);
            return this.dao.acceptSuggestionList(uriInfo, suggestions, suggestionType, securityContext, this.authorizer);
        }
        return new RestUtil.PutResponse<List<Suggestion>>(Response.Status.BAD_REQUEST, List.of(), EventType.SUGGESTION_REJECTED);
    }

    @PUT
    @Path(value="reject-all")
    @Operation(operationId="rejectAllSuggestion", summary="Reject all Suggestions from a user and an Entity", description="Reject all Suggestions from a user and an Entity", responses={@ApiResponse(responseCode="200", description="The suggestion.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggestion.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public RestUtil.PutResponse<List<Suggestion>> rejectAllSuggestions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="user id", schema=@Schema(type="string")) @QueryParam(value="userId") UUID userId, @Parameter(description="fullyQualifiedName of entity", schema=@Schema(type="string")) @QueryParam(value="entityFQN") String entityFQN, @Parameter(description="Suggestion type being rejected", schema=@Schema(type="string")) @QueryParam(value="suggestionType") @DefaultValue(value="SuggestDescription") SuggestionType suggestionType) {
        SuggestionFilter filter = SuggestionFilter.builder().suggestionStatus(SuggestionStatus.Open).entityFQN(entityFQN).createdBy(userId).suggestionType(suggestionType).build();
        List<Suggestion> suggestions = this.dao.listAll(filter);
        if (!CommonUtil.nullOrEmpty(suggestions)) {
            Suggestion suggestion = this.dao.get(suggestions.get(0).getId());
            this.dao.checkPermissionsForAcceptOrRejectSuggestion(suggestion, SuggestionStatus.Rejected, securityContext);
            return this.dao.rejectSuggestionList(uriInfo, suggestions, securityContext.getUserPrincipal().getName());
        }
        return new RestUtil.PutResponse<List<Suggestion>>(Response.Status.BAD_REQUEST, List.of(), EventType.SUGGESTION_REJECTED);
    }

    @PUT
    @Path(value="/{id}")
    @Operation(operationId="updateSuggestion", summary="Update a suggestion by `Id`.", description="Update an existing suggestion using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response updateSuggestion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Suggestion", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Valid Suggestion suggestion) {
        Suggestion origSuggestion = this.dao.get(id);
        this.dao.checkPermissionsForUpdateSuggestion(origSuggestion, securityContext);
        suggestion.setCreatedAt(origSuggestion.getCreatedAt());
        suggestion.setCreatedBy(origSuggestion.getCreatedBy());
        SuggestionsResource.addHref(uriInfo, this.dao.update(suggestion, securityContext.getUserPrincipal().getName()));
        return Response.created((URI)suggestion.getHref()).entity((Object)suggestion).header("X-OpenMetadata-Change", (Object)EventType.SUGGESTION_UPDATED).build();
    }

    @POST
    @Operation(operationId="createSuggestion", summary="Create a Suggestion", description="Create a new Suggestion. A Suggestion is created about a data asset when a user suggests an update.", responses={@ApiResponse(responseCode="200", description="The thread", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggestion.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createSuggestion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateSuggestion create) {
        Suggestion suggestion = this.getSuggestion(securityContext, create);
        SuggestionsResource.addHref(uriInfo, this.dao.create(suggestion));
        return Response.created((URI)suggestion.getHref()).entity((Object)suggestion).header("X-OpenMetadata-Change", (Object)EventType.SUGGESTION_CREATED).build();
    }

    @DELETE
    @Path(value="/{suggestionId}")
    @Operation(operationId="deleteSuggestion", summary="Delete a Suggestion by Id", description="Delete an existing Suggestion and all its relationships.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="thread with {threadId} is not found"), @ApiResponse(responseCode="400", description="Bad request")})
    public Response deleteSuggestion(@Context SecurityContext securityContext, @Parameter(description="ThreadId of the thread to be deleted", schema=@Schema(type="string")) @PathParam(value="suggestionId") UUID suggestionId) {
        Suggestion suggestion = this.dao.get(suggestionId);
        OperationContext operationContext = new OperationContext("SUGGESTION", MetadataOperation.DELETE);
        PostResourceContext resourceContext = new PostResourceContext(suggestion.getCreatedBy().getName());
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.dao.deleteSuggestion(suggestion, securityContext.getUserPrincipal().getName()).toResponse();
    }

    @DELETE
    @Path(value="/{entityType}/name/{entityFQN}")
    @Operation(operationId="deleteSuggestions", summary="Delete a Suggestions by entityFQN", description="Delete an existing Suggestions and all its relationships.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="thread with {threadId} is not found"), @ApiResponse(responseCode="400", description="Bad request")})
    public Response deleteSuggestions(@Context SecurityContext securityContext, @Parameter(description="entity type", schema=@Schema(type="string")) @PathParam(value="entityType") String entityType, @Parameter(description="fullyQualifiedName of entity", schema=@Schema(type="string")) @PathParam(value="entityFQN") String entityFQN) {
        EntityInterface entity = (EntityInterface)Entity.getEntityByName(entityType, entityFQN, "owner", Include.NON_DELETED);
        OperationContext operationContext = new OperationContext("SUGGESTION", MetadataOperation.DELETE);
        PostResourceContext resourceContext = new PostResourceContext(entity.getOwner().getName());
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.dao.deleteSuggestionsForAnEntity(entity, securityContext.getUserPrincipal().getName()).toResponse();
    }

    private Suggestion getSuggestion(SecurityContext securityContext, CreateSuggestion create) {
        this.validate(create);
        return new Suggestion().withId(UUID.randomUUID()).withDescription(create.getDescription()).withEntityLink(create.getEntityLink()).withType(create.getType()).withDescription(create.getDescription()).withTagLabels(create.getTagLabels()).withStatus(SuggestionStatus.Open).withCreatedBy(UserUtil.getUserOrBot(securityContext.getUserPrincipal().getName())).withCreatedAt(Long.valueOf(System.currentTimeMillis())).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
    }

    private void validate(CreateSuggestion suggestion) {
        if (suggestion.getEntityLink() == null) {
            throw new SuggestionException(Response.Status.BAD_REQUEST, "INVALID_SUGGESTION_REQUEST", "Suggestion's entityLink cannot be null.");
        }
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(suggestion.getEntityLink());
        Entity.getEntityReferenceByName(entityLink.getEntityType(), entityLink.getEntityFQN(), Include.NON_DELETED);
        if (suggestion.getType() == SuggestionType.SuggestDescription) {
            if (suggestion.getDescription() == null || suggestion.getDescription().isEmpty()) {
                throw new SuggestionException(Response.Status.BAD_REQUEST, "INVALID_SUGGESTION_REQUEST", "Suggestion's description cannot be empty.");
            }
        } else if (suggestion.getType() == SuggestionType.SuggestTagLabel) {
            if (suggestion.getTagLabels().isEmpty()) {
                throw new SuggestionException(Response.Status.BAD_REQUEST, "INVALID_SUGGESTION_REQUEST", "Suggestion's tag label's cannot be empty.");
            }
            for (TagLabel label : CommonUtil.listOrEmpty((List)suggestion.getTagLabels())) {
                TagLabelUtil.applyTagCommonFields(label);
            }
        } else {
            throw new SuggestionException(Response.Status.BAD_REQUEST, "INVALID_SUGGESTION_REQUEST", "Invalid Suggestion Type.");
        }
    }

    public static class SuggestionList
    extends ResultList<Suggestion> {
    }
}

