/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record DatabaseServiceIndex(DatabaseService databaseService) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.databaseService);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.databaseService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.databaseService.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.databaseService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "databaseService");
        doc.put("owner", this.getEntityWithDisplayName(this.databaseService.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.databaseService.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.databaseService.getFollowers()));
        return doc;
    }
}

