/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.BadJWTExceptions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmetadata.service.security.SecurityUtil;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/callback"})
public class AuthCallbackServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AuthCallbackServlet.class);
    private final OidcClient client;
    private final ClientAuthentication clientAuthentication;
    private final List<String> claimsOrder;
    private final String serverUrl;

    public AuthCallbackServlet(OidcClient oidcClient, String serverUrl, List<String> claimsOrder) {
        CommonHelper.assertNotBlank((String)"ServerUrl", (String)serverUrl);
        this.client = oidcClient;
        this.claimsOrder = claimsOrder;
        this.serverUrl = serverUrl;
        this.clientAuthentication = SecurityUtil.getClientAuthentication(this.client.getConfiguration());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String computedCallbackUrl = this.client.getCallbackUrl();
            Map<String, List<String>> parameters = this.retrieveParameters(req);
            AuthenticationResponse response = AuthenticationResponseParser.parse((URI)new URI(computedCallbackUrl), parameters);
            if (response instanceof AuthenticationErrorResponse) {
                AuthenticationErrorResponse authenticationErrorResponse = (AuthenticationErrorResponse)response;
                LOG.error("Bad authentication response, error={}", (Object)authenticationErrorResponse.getErrorObject());
                throw new TechnicalException("Bad authentication response");
            }
            LOG.debug("Authentication response successful");
            AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)response;
            OIDCProviderMetadata metadata = this.client.getConfiguration().getProviderMetadata();
            if (metadata.supportsAuthorizationResponseIssuerParam() && !metadata.getIssuer().equals((Object)successResponse.getIssuer())) {
                throw new TechnicalException("Issuer mismatch, possible mix-up attack.");
            }
            this.validateStateIfRequired(req, resp, successResponse);
            OidcCredentials credentials = this.buildCredentials(successResponse);
            this.validateAndSendTokenRequest(req, credentials, computedCallbackUrl);
            this.validateNonceIfRequired(req, credentials.getIdToken().getJWTClaimsSet());
            req.getSession().setAttribute("oidcCredentialProfile", (Object)credentials);
            SecurityUtil.sendRedirectWithToken(resp, credentials, this.serverUrl, this.claimsOrder);
        }
        catch (Exception e) {
            SecurityUtil.getErrorMessage(resp, e);
        }
    }

    private OidcCredentials buildCredentials(AuthenticationSuccessResponse successResponse) {
        AccessToken accessToken;
        JWT idToken;
        OidcCredentials credentials = new OidcCredentials();
        AuthorizationCode code = successResponse.getAuthorizationCode();
        if (code != null) {
            credentials.setCode(code);
        }
        if ((idToken = successResponse.getIDToken()) != null) {
            credentials.setIdToken(idToken);
        }
        if ((accessToken = successResponse.getAccessToken()) != null) {
            credentials.setAccessToken(accessToken);
        }
        return credentials;
    }

    private void validateNonceIfRequired(HttpServletRequest req, JWTClaimsSet claimsSet) throws BadJOSEException {
        if (this.client.getConfiguration().isUseNonce()) {
            String expectedNonce = (String)req.getSession().getAttribute(this.client.getNonceSessionAttributeName());
            if (CommonHelper.isNotBlank((String)expectedNonce)) {
                String tokenNonce;
                try {
                    tokenNonce = claimsSet.getStringClaim("nonce");
                }
                catch (ParseException var10) {
                    throw new BadJWTException("Invalid JWT nonce (nonce) claim: " + var10.getMessage());
                }
                if (tokenNonce == null) {
                    throw BadJWTExceptions.MISSING_NONCE_CLAIM_EXCEPTION;
                }
                if (!expectedNonce.equals(tokenNonce)) {
                    throw new BadJWTException("Unexpected JWT nonce (nonce) claim: " + tokenNonce);
                }
            } else {
                throw new TechnicalException("Missing nonce parameter from Session.");
            }
        }
    }

    private void validateStateIfRequired(HttpServletRequest req, HttpServletResponse resp, AuthenticationSuccessResponse successResponse) {
        if (this.client.getConfiguration().isWithState()) {
            State requestState = (State)req.getSession().getAttribute(this.client.getStateSessionAttributeName());
            if (requestState == null || CommonHelper.isBlank((String)requestState.getValue())) {
                SecurityUtil.getErrorMessage(resp, (Exception)new TechnicalException("Missing state parameter"));
                return;
            }
            State responseState = successResponse.getState();
            if (responseState == null) {
                throw new TechnicalException("Missing state parameter");
            }
            LOG.debug("Request state: {}/response state: {}", (Object)requestState, (Object)responseState);
            if (!requestState.equals((Object)responseState)) {
                throw new TechnicalException("State parameter is different from the one sent in authentication request.");
            }
        }
    }

    private void validateAndSendTokenRequest(HttpServletRequest req, OidcCredentials oidcCredentials, String computedCallbackUrl) throws IOException, com.nimbusds.oauth2.sdk.ParseException, URISyntaxException {
        if (oidcCredentials.getCode() != null) {
            CodeVerifier verifier = (CodeVerifier)req.getSession().getAttribute(this.client.getCodeVerifierSessionAttributeName());
            TokenRequest request = this.createTokenRequest((AuthorizationGrant)new AuthorizationCodeGrant(oidcCredentials.getCode(), new URI(computedCallbackUrl), verifier));
            this.executeTokenRequest(request, oidcCredentials);
        }
    }

    protected Map<String, List<String>> retrieveParameters(HttpServletRequest request) {
        Map requestParameters = request.getParameterMap();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : requestParameters.entrySet()) {
            map.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
        }
        return map;
    }

    protected TokenRequest createTokenRequest(AuthorizationGrant grant) {
        if (this.client.getConfiguration().getClientAuthenticationMethod() != null) {
            return new TokenRequest(this.client.getConfiguration().findProviderMetadata().getTokenEndpointURI(), this.clientAuthentication, grant);
        }
        return new TokenRequest(this.client.getConfiguration().findProviderMetadata().getTokenEndpointURI(), new ClientID(this.client.getConfiguration().getClientId()), grant);
    }

    private void executeTokenRequest(TokenRequest request, OidcCredentials credentials) throws IOException, com.nimbusds.oauth2.sdk.ParseException {
        HTTPRequest tokenHttpRequest = request.toHTTPRequest();
        this.client.getConfiguration().configureHttpRequest(tokenHttpRequest);
        HTTPResponse httpResponse = tokenHttpRequest.send();
        LOG.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
        TokenResponse response = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
        if (response instanceof TokenErrorResponse) {
            TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)response;
            ErrorObject errorObject = tokenErrorResponse.getErrorObject();
            throw new TechnicalException("Bad token response, error=" + errorObject.getCode() + ", description=" + errorObject.getDescription());
        }
        LOG.debug("Token response successful");
        OIDCTokenResponse tokenSuccessResponse = (OIDCTokenResponse)response;
        OIDCTokens oidcTokens = tokenSuccessResponse.getOIDCTokens();
        credentials.setAccessToken(oidcTokens.getAccessToken());
        credentials.setRefreshToken(oidcTokens.getRefreshToken());
        if (oidcTokens.getIDToken() != null) {
            credentials.setIdToken(oidcTokens.getIDToken());
        }
    }
}

