/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import java.util.Optional;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.security.AuthLoginServlet;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/v1/auth/refresh"})
public class AuthRefreshServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AuthRefreshServlet.class);
    private final OidcClient client;
    private final String baseUrl;

    public AuthRefreshServlet(OidcClient oidcClient, String url) {
        this.client = oidcClient;
        this.baseUrl = url;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            Optional<OidcCredentials> credentials = SecurityUtil.getUserCredentialsFromSession(req, this.client);
            if (credentials.isPresent()) {
                JwtResponse jwtResponse = new JwtResponse();
                jwtResponse.setAccessToken(credentials.get().getIdToken().getParsedString());
                jwtResponse.setExpiryDuration(credentials.get().getIdToken().getJWTClaimsSet().getExpirationTime().toInstant().getEpochSecond());
                AuthLoginServlet.writeJsonResponse(resp, JsonUtils.pojoToJson(jwtResponse));
            } else {
                resp.sendRedirect(String.format("%s/logout", this.baseUrl));
            }
        }
        catch (Exception e) {
            SecurityUtil.getErrorMessage(resp, (Exception)new TechnicalException((Throwable)e));
        }
    }
}

