/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.auth.PersonalAccessToken;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(UserTokenCache.class);
    private static final LoadingCache<String, HashSet<String>> CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new UserTokenLoader());
    private static volatile boolean initialized = false;
    private static TokenRepository tokenRepository;

    private UserTokenCache() {
    }

    public static void initialize() {
        if (!initialized) {
            tokenRepository = Entity.getTokenRepository();
            initialized = true;
            LOG.info("User Token cache is initialized");
        } else {
            LOG.debug("User Token cache is already initialized");
        }
    }

    public static Set<String> getToken(String userName) {
        try {
            return (Set)CACHE.get((Object)userName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            LOG.error("Token not found", ex);
            return null;
        }
    }

    public static void invalidateToken(String userName) {
        try {
            CACHE.invalidate((Object)userName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate User token cache for User {}", (Object)userName, (Object)ex);
        }
    }

    static class UserTokenLoader
    extends CacheLoader<String, HashSet<String>> {
        UserTokenLoader() {
        }

        @NonNull
        public HashSet<String> load(@CheckForNull String userName) {
            HashSet<String> result = new HashSet<String>();
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            User user = (User)userRepository.getByName(null, userName, new EntityUtil.Fields(Set.of("authenticationMechanism")), Include.NON_DELETED, true);
            List<TokenInterface> tokens = tokenRepository.findByUserIdAndType(user.getId(), TokenType.PERSONAL_ACCESS_TOKEN.value());
            tokens.forEach(t -> result.add(((PersonalAccessToken)t).getJwtToken()));
            return result;
        }
    }
}

