/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.prometheus.client.Histogram;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.openmetadata.service.util.MicrometerBundleSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMMicrometerHttpFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(OMMicrometerHttpFilter.class);
    protected FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Timer.Sample timer = Timer.start((MeterRegistry)MicrometerBundleSingleton.prometheusMeterRegistry);
        long startTime = System.nanoTime();
        chain.doFilter(request, response);
        double elapsed = (double)(System.nanoTime() - startTime) / 1.0E9;
        String requestMethod = ((HttpServletRequest)request).getMethod();
        ((Histogram.Child)MicrometerBundleSingleton.httpRequests.labels(new String[]{requestMethod})).observe(elapsed);
        timer.stop(MicrometerBundleSingleton.getRequestsLatencyTimer());
    }

    public void destroy() {
        LOG.info("OMMicrometerHttpFilter destroyed.");
    }
}

