/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util.jdbi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.openmetadata.service.util.jdbi.DatabaseAuthenticationProvider;
import org.openmetadata.service.util.jdbi.DatabaseAuthenticationProviderException;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsUtilities;
import software.amazon.awssdk.services.rds.model.GenerateAuthenticationTokenRequest;

public class AwsRdsDatabaseAuthenticationProvider
implements DatabaseAuthenticationProvider {
    public static final String AWS_REGION = "awsRegion";
    public static final String ALLOW_PUBLIC_KEY_RETRIEVAL = "allowPublicKeyRetrieval";
    public static final String PROTOCOL = "https://";

    @Override
    public String authenticate(String jdbcUrl, String username, String password) {
        try {
            URI uri = URI.create(PROTOCOL + AwsRdsDatabaseAuthenticationProvider.removeProtocolFrom(jdbcUrl));
            Map<String, String> queryParams = this.parseQueryParams(uri.toURL());
            String awsRegion = queryParams.get(AWS_REGION);
            String allowPublicKeyRetrieval = queryParams.get(ALLOW_PUBLIC_KEY_RETRIEVAL);
            Objects.requireNonNull(awsRegion, "Parameter `awsRegion` shall be provided in the jdbc url.");
            Objects.requireNonNull(allowPublicKeyRetrieval, "Parameter `allowPublicKeyRetrieval` shall be provided in the jdbc url.");
            GenerateAuthenticationTokenRequest request = GenerateAuthenticationTokenRequest.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).hostname(uri.getHost()).port(uri.getPort()).username(username).build();
            return RdsUtilities.builder().region(Region.of((String)awsRegion)).build().generateAuthenticationToken(request);
        }
        catch (MalformedURLException e) {
            throw new DatabaseAuthenticationProviderException(e);
        }
    }

    @NotNull
    private static String removeProtocolFrom(String jdbcUrl) {
        return jdbcUrl.substring(jdbcUrl.indexOf("://") + 3);
    }

    private Map<String, String> parseQueryParams(URL url) {
        String[] pairs;
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryPairs.put(URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8), URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8));
        }
        return queryPairs;
    }
}

