/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.dataInsight.type.PercentageOfEntitiesWithDescriptionByType;
import org.openmetadata.schema.dataInsight.type.PercentageOfEntitiesWithOwnerByType;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByTier;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByType;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.applications.configuration.internal.DataInsightsReportAppConfig;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.DataReportIndex;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.AbstractNativeApplication;
import org.openmetadata.service.events.scheduled.template.DataInsightDescriptionAndOwnerTemplate;
import org.openmetadata.service.events.scheduled.template.DataInsightTotalAssetTemplate;
import org.openmetadata.service.exception.EventSubscriptionJobException;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.KpiRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.SubscriptionUtil;
import org.openmetadata.service.util.Utilities;
import org.openmetadata.service.workflows.searchIndex.PaginatedEntitiesSource;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInsightsReportApp
extends AbstractNativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightsReportApp.class);
    private static final String KPI_NOT_SET = "No Kpi Set";

    public DataInsightsReportApp(CollectionDAO collectionDAO, SearchRepository searchRepository) {
        super(collectionDAO, searchRepository);
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) {
        String appName = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"appName");
        App app = (App)this.collectionDAO.applicationDAO().findEntityByName(appName);
        long currentTime = Instant.now().toEpochMilli();
        long scheduleTime = currentTime - 604800000L;
        int numberOfDaysChange = 7;
        try {
            DataInsightsReportAppConfig insightAlertConfig = JsonUtils.convertValue(app.getAppConfiguration(), DataInsightsReportAppConfig.class);
            if (Boolean.TRUE.equals(insightAlertConfig.getSendToAdmins())) {
                this.sendToAdmins(this.searchRepository.getSearchClient(), scheduleTime, currentTime, numberOfDaysChange);
            }
            if (Boolean.FALSE.equals(insightAlertConfig.getSendToTeams())) {
                this.sendReportsToTeams(this.searchRepository.getSearchClient(), scheduleTime, currentTime, numberOfDaysChange);
            }
        }
        catch (Exception e) {
            LOG.error("[DIReport] Failed in sending report due to", (Throwable)e);
            throw new EventSubscriptionJobException(e);
        }
    }

    private void sendReportsToTeams(SearchClient searchClient, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws SearchIndexException {
        PaginatedEntitiesSource teamReader = new PaginatedEntitiesSource("team", 10, List.of("name", "email", "users"));
        while (!teamReader.isDone()) {
            Object resultList = teamReader.readNext((Map)null);
            for (Team team : ((ResultList)resultList).getData()) {
                HashSet<String> emails = new HashSet<String>();
                String email = team.getEmail();
                if (!CommonUtil.nullOrEmpty((String)email)) {
                    emails.add(email);
                } else {
                    for (EntityReference userRef : team.getUsers()) {
                        User user = (User)Entity.getEntity("user", userRef.getId(), "", Include.NON_DELETED);
                        emails.add(user.getEmail());
                    }
                }
                try {
                    DataInsightTotalAssetTemplate totalAssetTemplate = this.createTotalAssetTemplate(searchClient, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    DataInsightDescriptionAndOwnerTemplate descriptionTemplate = this.createDescriptionTemplate(searchClient, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    DataInsightDescriptionAndOwnerTemplate ownershipTemplate = this.createOwnershipTemplate(searchClient, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    DataInsightDescriptionAndOwnerTemplate tierTemplate = this.createTierTemplate(searchClient, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    EmailUtil.sendDataInsightEmailNotificationToUser(emails, Utilities.getMonthAndDateFromEpoch(scheduleTime), Utilities.getMonthAndDateFromEpoch(currentTime), totalAssetTemplate, descriptionTemplate, ownershipTemplate, tierTemplate, EmailUtil.getDataInsightReportSubject(), "dataInsightReport.ftl");
                }
                catch (Exception ex) {
                    LOG.error("[DataInsightReport] Failed for Team: {}, Reason : {}", (Object)team.getName(), (Object)ex.getMessage());
                }
            }
        }
    }

    private void sendToAdmins(SearchClient searchClient, Long scheduleTime, Long currentTime, int numberOfDaysChange) {
        Set<String> emailList = SubscriptionUtil.getAdminsData(SubscriptionDestination.SubscriptionType.EMAIL);
        try {
            DataInsightTotalAssetTemplate totalAssetTemplate = this.createTotalAssetTemplate(searchClient, null, scheduleTime, currentTime, numberOfDaysChange);
            DataInsightDescriptionAndOwnerTemplate descriptionTemplate = this.createDescriptionTemplate(searchClient, null, scheduleTime, currentTime, numberOfDaysChange);
            DataInsightDescriptionAndOwnerTemplate ownershipTemplate = this.createOwnershipTemplate(searchClient, null, scheduleTime, currentTime, numberOfDaysChange);
            DataInsightDescriptionAndOwnerTemplate tierTemplate = this.createTierTemplate(searchClient, null, scheduleTime, currentTime, numberOfDaysChange);
            EmailUtil.sendDataInsightEmailNotificationToUser(emailList, Utilities.getMonthAndDateFromEpoch(scheduleTime), Utilities.getMonthAndDateFromEpoch(currentTime), totalAssetTemplate, descriptionTemplate, ownershipTemplate, tierTemplate, EmailUtil.getDataInsightReportSubject(), "dataInsightReport.ftl");
        }
        catch (Exception ex) {
            LOG.error("[DataInsightReport] Failed for Admin, Reason : {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private List<Kpi> getAvailableKpi() {
        KpiRepository repository = (KpiRepository)Entity.getEntityRepository("kpi");
        return repository.listAll(repository.getFields("dataInsightChart"), new ListFilter(Include.NON_DELETED));
    }

    private KpiResult getKpiResult(String fqn) {
        KpiRepository repository = (KpiRepository)Entity.getEntityRepository("kpi");
        return repository.getKpiResult(fqn);
    }

    private DataInsightTotalAssetTemplate createTotalAssetTemplate(SearchClient searchClient, String team, Long scheduleTime, Long currentTime, int numberOfDays) throws ParseException, IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(currentTime).forEach(day -> dateMap.put((String)day, 0));
        TreeMap<Long, List<Object>> dateWithDataMap = searchClient.getSortedDate(team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.TOTAL_ENTITIES_BY_TYPE, DataReportIndex.ENTITY_REPORT_DATA_INDEX.value());
        if (dateWithDataMap.firstEntry() != null && dateWithDataMap.lastEntry() != null) {
            List<TotalEntitiesByType> first = JsonUtils.convertValue(dateWithDataMap.firstEntry().getValue(), new TypeReference<List<TotalEntitiesByType>>(){});
            List<TotalEntitiesByType> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<TotalEntitiesByType>>(){});
            Double previousCount = this.getCountOfEntitiesFromList(first);
            Double currentCount = this.getCountOfEntitiesFromList(last);
            dateWithDataMap.forEach((key, value) -> {
                List<TotalEntitiesByType> list = JsonUtils.convertValue(value, new TypeReference<List<TotalEntitiesByType>>(){});
                Double count = this.getCountOfEntitiesFromList(list);
                dateMap.put(Utilities.getDateFromEpoch(key), count.intValue());
            });
            this.processDateMapToNormalize(dateMap);
            if (previousCount == 0.0) {
                return new DataInsightTotalAssetTemplate(currentCount, 0.0, numberOfDays, dateMap);
            }
            return new DataInsightTotalAssetTemplate(currentCount, (currentCount - previousCount) / previousCount * 100.0, numberOfDays, dateMap);
        }
        return new DataInsightTotalAssetTemplate(0.0, 0.0, numberOfDays, dateMap);
    }

    private DataInsightDescriptionAndOwnerTemplate createDescriptionTemplate(SearchClient searchClient, String team, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws ParseException, IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(currentTime).forEach(day -> dateMap.put((String)day, 0));
        TreeMap<Long, List<Object>> dateWithDataMap = searchClient.getSortedDate(team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE, DataReportIndex.ENTITY_REPORT_DATA_INDEX.value());
        if (dateWithDataMap.firstEntry() != null && dateWithDataMap.lastEntry() != null) {
            List<PercentageOfEntitiesWithDescriptionByType> first = JsonUtils.convertValue(dateWithDataMap.firstEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithDescriptionByType>>(){});
            List<PercentageOfEntitiesWithDescriptionByType> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithDescriptionByType>>(){});
            double previousCompletedDescription = this.getCompletedDescriptionCount(first);
            double previousTotalCount = this.getTotalEntityFromDescriptionList(first);
            double currentCompletedDescription = this.getCompletedDescriptionCount(last);
            double currentTotalCount = this.getTotalEntityFromDescriptionList(last);
            dateWithDataMap.forEach((key, value) -> {
                List<PercentageOfEntitiesWithDescriptionByType> list = JsonUtils.convertValue(value, new TypeReference<List<PercentageOfEntitiesWithDescriptionByType>>(){});
                Double count = this.getCompletedDescriptionCount(list);
                dateMap.put(Utilities.getDateFromEpoch(key), count.intValue());
            });
            this.processDateMapToNormalize(dateMap);
            double previousPercentCompleted = 0.0;
            if (previousTotalCount != 0.0) {
                previousPercentCompleted = previousCompletedDescription / previousTotalCount * 100.0;
            }
            double currentPercentCompleted = 0.0;
            if (currentTotalCount != 0.0) {
                currentPercentCompleted = currentCompletedDescription / currentTotalCount * 100.0;
            }
            return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.DESCRIPTION, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE, currentPercentCompleted, currentPercentCompleted - previousPercentCompleted, (int)currentCompletedDescription, numberOfDaysChange, dateMap);
        }
        return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.DESCRIPTION, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE, 0.0, 0.0, 0, numberOfDaysChange, dateMap);
    }

    private DataInsightDescriptionAndOwnerTemplate createOwnershipTemplate(SearchClient searchClient, String team, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws ParseException, IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(currentTime).forEach(day -> dateMap.put((String)day, 0));
        TreeMap<Long, List<Object>> dateWithDataMap = searchClient.getSortedDate(team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE, DataReportIndex.ENTITY_REPORT_DATA_INDEX.value());
        if (dateWithDataMap.firstEntry() != null && dateWithDataMap.lastEntry() != null) {
            List<PercentageOfEntitiesWithOwnerByType> first = JsonUtils.convertValue(dateWithDataMap.firstEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithOwnerByType>>(){});
            List<PercentageOfEntitiesWithOwnerByType> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithOwnerByType>>(){});
            double previousHasOwner = this.getCompletedOwnershipCount(first);
            double previousTotalCount = this.getTotalEntityFromOwnerList(first);
            double currentHasOwner = this.getCompletedOwnershipCount(last);
            double currentTotalCount = this.getTotalEntityFromOwnerList(last);
            double previousPercentCompleted = 0.0;
            if (previousTotalCount != 0.0) {
                previousPercentCompleted = previousHasOwner / previousTotalCount * 100.0;
            }
            double currentPercentCompleted = 0.0;
            if (currentTotalCount != 0.0) {
                currentPercentCompleted = currentHasOwner / currentTotalCount * 100.0;
            }
            dateWithDataMap.forEach((key, value) -> {
                List<PercentageOfEntitiesWithOwnerByType> list = JsonUtils.convertValue(value, new TypeReference<List<PercentageOfEntitiesWithOwnerByType>>(){});
                Double count = this.getCompletedOwnershipCount(list);
                dateMap.put(Utilities.getDateFromEpoch(key), count.intValue());
            });
            this.processDateMapToNormalize(dateMap);
            return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.OWNER, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE, currentPercentCompleted, currentPercentCompleted - previousPercentCompleted, (int)currentHasOwner, numberOfDaysChange, dateMap);
        }
        return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.OWNER, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE, 0.0, 0.0, 0, numberOfDaysChange, dateMap);
    }

    private DataInsightDescriptionAndOwnerTemplate createTierTemplate(SearchClient searchClient, String team, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws ParseException, IOException {
        LinkedHashMap<String, Integer> dateMap = new LinkedHashMap<String, Integer>();
        Utilities.getLastSevenDays(currentTime).forEach(day -> dateMap.put((String)day, 0));
        TreeMap<Long, List<Object>> dateWithDataMap = searchClient.getSortedDate(team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.TOTAL_ENTITIES_BY_TIER, DataReportIndex.ENTITY_REPORT_DATA_INDEX.value());
        if (dateWithDataMap.lastEntry() != null) {
            List<TotalEntitiesByTier> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<TotalEntitiesByTier>>(){});
            dateWithDataMap.forEach((key, value) -> {
                List<TotalEntitiesByTier> list = JsonUtils.convertValue(value, new TypeReference<List<TotalEntitiesByTier>>(){});
                Double count = this.getCountOfTieredEntities(list);
                dateMap.put(Utilities.getDateFromEpoch(key), count.intValue());
            });
            this.processDateMapToNormalize(dateMap);
            Map<String, Double> tierData = this.getTierData(last);
            return new DataInsightDescriptionAndOwnerTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.TIER, null, "0", 0.0, KPI_NOT_SET, 0.0, false, "", numberOfDaysChange, tierData, dateMap);
        }
        return new DataInsightDescriptionAndOwnerTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.TIER, null, "0", 0.0, KPI_NOT_SET, 0.0, false, "", numberOfDaysChange, new HashMap<String, Double>(), dateMap);
    }

    private Double getCountOfEntitiesFromList(List<TotalEntitiesByType> entitiesByTypeList) {
        Double totalCount = 0.0;
        for (TotalEntitiesByType obj : entitiesByTypeList) {
            totalCount = totalCount + obj.getEntityCount();
        }
        return totalCount;
    }

    private Double getCountOfTieredEntities(List<TotalEntitiesByTier> entitiesByTierList) {
        double totalCount = 0.0;
        for (TotalEntitiesByTier obj : entitiesByTierList) {
            totalCount += obj.getEntityCountFraction() * 100.0;
        }
        return totalCount;
    }

    private Map<String, Double> getTierData(List<TotalEntitiesByTier> entitiesByTypeList) {
        TreeMap<String, Double> data = new TreeMap<String, Double>();
        for (TotalEntitiesByTier obj : entitiesByTypeList) {
            data.put(obj.getEntityTier(), obj.getEntityCountFraction() * 100.0);
        }
        return data;
    }

    private Double getTotalEntityFromDescriptionList(List<PercentageOfEntitiesWithDescriptionByType> entitiesByTypeList) {
        Double totalCount = 0.0;
        for (PercentageOfEntitiesWithDescriptionByType obj : entitiesByTypeList) {
            totalCount = totalCount + obj.getEntityCount();
        }
        return totalCount;
    }

    private Double getCompletedDescriptionCount(List<PercentageOfEntitiesWithDescriptionByType> entitiesByTypeList) {
        Double completedDescriptions = 0.0;
        for (PercentageOfEntitiesWithDescriptionByType obj : entitiesByTypeList) {
            completedDescriptions = completedDescriptions + obj.getCompletedDescription();
        }
        return completedDescriptions;
    }

    private Double getTotalEntityFromOwnerList(List<PercentageOfEntitiesWithOwnerByType> entitiesByTypeList) {
        Double totalCount = 0.0;
        for (PercentageOfEntitiesWithOwnerByType obj : entitiesByTypeList) {
            totalCount = totalCount + obj.getEntityCount();
        }
        return totalCount;
    }

    private Double getCompletedOwnershipCount(List<PercentageOfEntitiesWithOwnerByType> entitiesByTypeList) {
        Double hasOwner = 0.0;
        for (PercentageOfEntitiesWithOwnerByType obj : entitiesByTypeList) {
            hasOwner = hasOwner + obj.getHasOwner();
        }
        return hasOwner;
    }

    private DataInsightDescriptionAndOwnerTemplate getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType metricType, DataInsightChartResult.DataInsightChartType chartType, Double percentCompleted, Double percentChange, int totalAssets, int numberOfDaysChange, Map<String, Integer> dateMap) {
        List<Kpi> kpiList = this.getAvailableKpi();
        Kpi validKpi = null;
        boolean isKpiAvailable = false;
        for (Kpi kpiObj : kpiList) {
            if (!Objects.equals(kpiObj.getDataInsightChart().getName(), chartType.value())) continue;
            validKpi = kpiObj;
            isKpiAvailable = true;
            break;
        }
        DataInsightDescriptionAndOwnerTemplate.KpiCriteria criteria = null;
        String totalDaysLeft = "";
        String targetKpi = KPI_NOT_SET;
        if (isKpiAvailable) {
            targetKpi = String.format("%.2f", Double.parseDouble(((KpiTarget)validKpi.getTargetDefinition().get(0)).getValue()) * 100.0);
            KpiResult result = this.getKpiResult(validKpi.getName());
            if (result != null) {
                boolean isTargetMet = ((KpiTarget)result.getTargetResult().get(0)).getTargetMet();
                criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.IN_PROGRESS;
                if (isTargetMet) {
                    criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.MET;
                } else {
                    long leftDaysInMilli = validKpi.getEndDate() - System.currentTimeMillis();
                    if (leftDaysInMilli >= 0L) {
                        totalDaysLeft = String.valueOf((int)(leftDaysInMilli / 86400000L));
                    } else {
                        criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.NOT_MET;
                    }
                }
            }
        }
        return new DataInsightDescriptionAndOwnerTemplate(metricType, criteria, String.valueOf(totalAssets), percentCompleted, targetKpi, percentChange, isKpiAvailable, totalDaysLeft, numberOfDaysChange, null, dateMap);
    }

    private void processDateMapToNormalize(Map<String, Integer> dateMap) {
        Pair<Integer, Integer> maxIn = this.getMinAndMax(dateMap.values().stream().toList());
        dateMap.replaceAll((k, v) -> this.getNormalizedValue(v.doubleValue(), ((Integer)maxIn.getRight()).doubleValue(), ((Integer)maxIn.getLeft()).doubleValue()).intValue());
    }

    private Pair<Integer, Integer> getMinAndMax(List<Integer> integers) {
        Optional minOptional = integers.stream().min(Integer::compareTo);
        Optional maxOptional = integers.stream().max(Integer::compareTo);
        int min = (Integer)minOptional.orElseThrow(() -> new IllegalArgumentException("List is empty"));
        int max = (Integer)maxOptional.orElseThrow(() -> new IllegalArgumentException("List is empty"));
        return Pair.of((Object)min, (Object)max);
    }

    private Double getNormalizedValue(Double value, Double max, Double min) {
        if (max - min == 0.0) {
            return 0.0;
        }
        return (value - min) / (max - min) * 50.0;
    }
}

