/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.gchat.GChatMessage;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.decorators.OutgoingMessage;
import org.openmetadata.service.util.EmailUtil;

public class GChatMessageDecorator
implements MessageDecorator<GChatMessage> {
    @Override
    public String getBold() {
        return "<b>%s</b>";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "<b>";
    }

    @Override
    public String getAddMarkerClose() {
        return "</b>";
    }

    @Override
    public String getRemoveMarker() {
        return "<s>";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "</s>";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn, String additionalParams) {
        return String.format("<%s/%s/%s%s|%s>", EmailUtil.getSmtpSettings().getOpenMetadataUrl(), entityType, fqn.trim().replace(" ", "%20"), CommonUtil.nullOrEmpty((String)additionalParams) ? "" : String.format("/%s", additionalParams), fqn.trim());
    }

    @Override
    public GChatMessage buildEntityMessage(ChangeEvent event) {
        return this.getGChatMessage(this.createEntityMessage(event));
    }

    @Override
    public GChatMessage buildThreadMessage(ChangeEvent event) {
        return this.getGChatMessage(this.createThreadMessage(event));
    }

    private GChatMessage getGChatMessage(OutgoingMessage outgoingMessage) {
        if (!outgoingMessage.getMessages().isEmpty()) {
            GChatMessage gChatMessage = new GChatMessage();
            GChatMessage.CardsV2 cardsV2 = new GChatMessage.CardsV2();
            GChatMessage.Card card = new GChatMessage.Card();
            GChatMessage.Section section = new GChatMessage.Section();
            gChatMessage.setText("Change Event from OpenMetadata");
            GChatMessage.CardHeader cardHeader = new GChatMessage.CardHeader();
            cardHeader.setTitle(outgoingMessage.getHeader());
            card.setHeader(cardHeader);
            ArrayList<GChatMessage.Widget> widgets = new ArrayList<GChatMessage.Widget>();
            outgoingMessage.getMessages().forEach(m -> widgets.add(this.getGChatWidget((String)m)));
            section.setWidgets(widgets);
            card.setSections(List.of(section));
            cardsV2.setCard(card);
            gChatMessage.setCardsV2(List.of(cardsV2));
            return gChatMessage;
        }
        throw new UnhandledServerException("No messages found for the event");
    }

    private GChatMessage.Widget getGChatWidget(String message) {
        GChatMessage.Widget widget = new GChatMessage.Widget();
        widget.setTextParagraph(new GChatMessage.TextParagraph(message));
        return widget;
    }
}

