/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.util.ArrayList;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.slack.SlackAttachment;
import org.openmetadata.service.apps.bundles.changeEvent.slack.SlackMessage;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.decorators.OutgoingMessage;
import org.openmetadata.service.util.EmailUtil;

public class SlackMessageDecorator
implements MessageDecorator<SlackMessage> {
    @Override
    public String getBold() {
        return "*%s*";
    }

    @Override
    public String getLineBreak() {
        return "\n";
    }

    @Override
    public String getAddMarker() {
        return "*";
    }

    @Override
    public String getAddMarkerClose() {
        return "*";
    }

    @Override
    public String getRemoveMarker() {
        return "~";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "~";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn, String additionalParams) {
        return String.format("<%s/%s/%s%s|%s>", EmailUtil.getSmtpSettings().getOpenMetadataUrl(), entityType, fqn.trim().replaceAll(" ", "%20"), CommonUtil.nullOrEmpty((String)additionalParams) ? "" : String.format("/%s", additionalParams), fqn.trim());
    }

    @Override
    public SlackMessage buildEntityMessage(ChangeEvent event) {
        return this.getSlackMessage(this.createEntityMessage(event));
    }

    @Override
    public SlackMessage buildThreadMessage(ChangeEvent event) {
        return this.getSlackMessage(this.createThreadMessage(event));
    }

    private SlackMessage getSlackMessage(OutgoingMessage outgoingMessage) {
        if (!outgoingMessage.getMessages().isEmpty()) {
            SlackMessage message = new SlackMessage();
            ArrayList attachmentList = new ArrayList();
            outgoingMessage.getMessages().forEach(m -> attachmentList.add(this.getSlackAttachment((String)m)));
            message.setUsername(outgoingMessage.getUserName());
            message.setText(outgoingMessage.getHeader());
            message.setAttachments(attachmentList.toArray(new SlackAttachment[0]));
            return message;
        }
        throw new UnhandledServerException("No messages found for the event");
    }

    private SlackAttachment getSlackAttachment(String message) {
        SlackAttachment attachment = new SlackAttachment();
        ArrayList<String> mark = new ArrayList<String>();
        mark.add("text");
        attachment.setMarkdownIn(mark);
        attachment.setText(message);
        return attachment;
    }
}

