/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.resources.feeds.MessageParser;

public class OwnerFormatter
extends DefaultFieldFormatter {
    public OwnerFormatter(MessageDecorator<?> messageDecorator, String fieldOldValue, String fieldNewValue, String fieldChangeName, MessageParser.EntityLink entityLink) {
        super(messageDecorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
    }

    @Override
    public String formatUpdatedField() {
        Object diff = this.getMessageDecorator().httpRemoveMarker() + this.getFieldOldValue() + this.getMessageDecorator().httpRemoveMarker() + " changed to " + this.getMessageDecorator().httpAddMarker() + this.getFieldNewValue() + this.getMessageDecorator().httpAddMarker();
        String spanAdd = this.getMessageDecorator().getAddMarker();
        String spanAddClose = this.getMessageDecorator().getAddMarkerClose();
        String spanRemove = this.getMessageDecorator().getRemoveMarker();
        String spanRemoveClose = this.getMessageDecorator().getRemoveMarkerClose();
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpAddMarker(), spanAdd, spanAddClose);
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpRemoveMarker(), spanRemove, spanRemoveClose);
        if (CommonUtil.nullOrEmpty((String)diff)) {
            return "";
        }
        String field = String.format("Updated %s: %s", this.getMessageDecorator().getBold(), diff);
        return String.format(field, this.getFieldChangeName());
    }
}

