/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.Assigned;
import org.openmetadata.schema.tests.type.Resolved;
import org.openmetadata.schema.tests.type.Severity;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatus;
import org.openmetadata.schema.tests.type.TestCaseResolutionStatusTypes;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.IncidentManagerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityTimeSeriesRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.incidentSeverityClassifier.IncidentSeverityClassifierInterface;

public class TestCaseResolutionStatusRepository
extends EntityTimeSeriesRepository<TestCaseResolutionStatus> {
    public static final String COLLECTION_PATH = "/v1/dataQuality/testCases/testCaseIncidentStatus";

    public TestCaseResolutionStatusRepository() {
        super(COLLECTION_PATH, Entity.getCollectionDAO().testCaseResolutionStatusTimeSeriesDao(), TestCaseResolutionStatus.class, "testCaseResolutionStatus");
    }

    public ResultList<TestCaseResolutionStatus> listTestCaseResolutionStatusesForStateId(UUID stateId) {
        List<String> jsons = ((CollectionDAO.TestCaseResolutionStatusTimeSeriesDAO)this.timeSeriesDao).listTestCaseResolutionStatusesForStateId(stateId.toString());
        List<TestCaseResolutionStatus> testCaseResolutionStatuses = JsonUtils.readObjects(jsons, TestCaseResolutionStatus.class);
        return this.getResultList(testCaseResolutionStatuses, null, null, testCaseResolutionStatuses.size());
    }

    public RestUtil.PatchResponse<TestCaseResolutionStatus> patch(UUID id, JsonPatch patch, String user) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        String originalJson = this.timeSeriesDao.getById(id);
        if (originalJson == null) {
            throw new EntityNotFoundException(String.format("Entity with id %s not found", id));
        }
        TestCaseResolutionStatus original = (TestCaseResolutionStatus)JsonUtils.readValue(originalJson, this.entityClass);
        TestCaseResolutionStatus updated = JsonUtils.applyPatch(original, patch, this.entityClass);
        updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        updated.setUpdatedBy(EntityUtil.getEntityReference("User", user));
        this.validatePatchFields(updated, original);
        this.timeSeriesDao.update(JsonUtils.pojoToJson(updated), id);
        return new RestUtil.PatchResponse<TestCaseResolutionStatus>(Response.Status.OK, updated, EventType.ENTITY_UPDATED);
    }

    private void validatePatchFields(TestCaseResolutionStatus updated, TestCaseResolutionStatus original) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        BeanInfo beanInfo = Introspector.getBeanInfo(TestCaseResolutionStatus.class);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            String propertyName = propertyDescriptor.getName();
            if (propertyName.equals("updatedBy") || propertyName.equals("updatedAt") || propertyName.equals("severity")) continue;
            Object originalValue = propertyDescriptor.getReadMethod().invoke((Object)original, new Object[0]);
            Object updatedValue = propertyDescriptor.getReadMethod().invoke((Object)updated, new Object[0]);
            if (originalValue == null || originalValue.equals(updatedValue)) continue;
            throw new IllegalArgumentException(String.format("Field %s is not allowed to be updated", propertyName));
        }
    }

    public Boolean unresolvedIncident(TestCaseResolutionStatus incident) {
        return incident != null && !incident.getTestCaseResolutionStatusType().equals((Object)TestCaseResolutionStatusTypes.Resolved);
    }

    private Thread getIncidentTask(TestCaseResolutionStatus incident) {
        String jsonThread = Entity.getCollectionDAO().feedDAO().fetchThreadByTestCaseResolutionStatusId(incident.getStateId());
        return JsonUtils.readValue(jsonThread, Thread.class);
    }

    private void validateStatus(TestCaseResolutionStatusTypes lastStatus, TestCaseResolutionStatusTypes newStatus) {
        switch (lastStatus) {
            case New: {
                break;
            }
            case Ack: {
                if (!newStatus.equals((Object)TestCaseResolutionStatusTypes.New)) break;
                throw IncidentManagerException.invalidStatus(lastStatus, newStatus);
            }
            case Assigned: {
                if (!List.of(TestCaseResolutionStatusTypes.New, TestCaseResolutionStatusTypes.Ack).contains(newStatus)) break;
                throw IncidentManagerException.invalidStatus(lastStatus, newStatus);
            }
            default: {
                throw IncidentManagerException.invalidStatus(lastStatus, newStatus);
            }
        }
    }

    @Override
    @Transaction
    public TestCaseResolutionStatus createNewRecord(TestCaseResolutionStatus recordEntity, String recordFQN) {
        TestCaseResolutionStatus lastIncident = (TestCaseResolutionStatus)this.getLatestRecord(recordEntity.getTestCaseReference().getFullyQualifiedName());
        if (recordEntity.getStateId() == null) {
            recordEntity.setStateId(UUID.randomUUID());
        }
        if (Boolean.TRUE.equals(this.unresolvedIncident(lastIncident))) {
            this.validateStatus(lastIncident.getTestCaseResolutionStatusType(), recordEntity.getTestCaseResolutionStatusType());
            recordEntity.setStateId(lastIncident.getStateId());
            recordEntity.setSeverity(recordEntity.getSeverity() == null ? lastIncident.getSeverity() : recordEntity.getSeverity());
        }
        this.inferIncidentSeverity(recordEntity);
        switch (recordEntity.getTestCaseResolutionStatusType()) {
            case New: {
                if (!Boolean.TRUE.equals(this.unresolvedIncident(lastIncident))) break;
                return lastIncident;
            }
            case Ack: 
            case Assigned: {
                this.openOrAssignTask(recordEntity);
                break;
            }
            case Resolved: {
                this.resolveTask(recordEntity, lastIncident);
                return (TestCaseResolutionStatus)this.getLatestRecord(recordEntity.getTestCaseReference().getFullyQualifiedName());
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid status %s", recordEntity.getTestCaseResolutionStatusType()));
            }
        }
        return super.createNewRecord(recordEntity, recordFQN);
    }

    private void openOrAssignTask(TestCaseResolutionStatus incidentStatus) {
        switch (incidentStatus.getTestCaseResolutionStatusType()) {
            case Ack: {
                this.createTask(incidentStatus, Collections.singletonList(incidentStatus.getUpdatedBy()), "New Incident");
                break;
            }
            case Assigned: {
                Thread existingTask = this.getIncidentTask(incidentStatus);
                Assigned assigned = JsonUtils.convertValue(incidentStatus.getTestCaseResolutionStatusDetails(), Assigned.class);
                if (existingTask == null) {
                    this.createTask(incidentStatus, Collections.singletonList(assigned.getAssignee()), "New Incident");
                    break;
                }
                this.patchTaskAssignee(existingTask, assigned.getAssignee(), incidentStatus.getUpdatedBy().getName());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Task cannot be opened for status `%s`", incidentStatus.getTestCaseResolutionStatusType()));
            }
        }
    }

    private void resolveTask(TestCaseResolutionStatus newIncidentStatus, TestCaseResolutionStatus lastIncidentStatus) {
        if (lastIncidentStatus == null) {
            throw new IncidentManagerException(String.format("Cannot find the last incident status for stateId %s", newIncidentStatus.getStateId()));
        }
        Resolved resolved = JsonUtils.convertValue(newIncidentStatus.getTestCaseResolutionStatusDetails(), Resolved.class);
        TestCase testCase = (TestCase)Entity.getEntity("testCase", newIncidentStatus.getTestCaseReference().getId(), "", Include.ALL);
        User updatedBy = (User)Entity.getEntity("user", newIncidentStatus.getUpdatedBy().getId(), "", Include.ALL);
        ResolveTask resolveTask = new ResolveTask().withTestCaseFQN(testCase.getFullyQualifiedName()).withTestCaseFailureReason(resolved.getTestCaseFailureReason()).withNewValue(resolved.getTestCaseFailureComment());
        Thread thread = this.getIncidentTask(lastIncidentStatus);
        if (thread != null) {
            Entity.getFeedRepository().resolveTask(new FeedRepository.ThreadContext(thread), updatedBy.getFullyQualifiedName(), resolveTask);
        } else {
            super.createNewRecord(newIncidentStatus, testCase.getFullyQualifiedName());
        }
    }

    private void createTask(TestCaseResolutionStatus incidentStatus, List<EntityReference> assignees, String message) {
        TaskDetails taskDetails = new TaskDetails().withAssignees(assignees).withType(TaskType.RequestTestCaseFailureResolution).withStatus(TaskStatus.Open).withTestCaseResolutionStatusId(incidentStatus.getStateId());
        MessageParser.EntityLink entityLink = new MessageParser.EntityLink("testCase", incidentStatus.getTestCaseReference().getFullyQualifiedName());
        Thread thread = new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withMessage(message).withCreatedBy(incidentStatus.getUpdatedBy().getName()).withAbout(entityLink.getLinkString()).withType(ThreadType.Task).withTask(taskDetails).withUpdatedBy(incidentStatus.getUpdatedBy().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        FeedRepository feedRepository = Entity.getFeedRepository();
        feedRepository.create(thread);
    }

    private void patchTaskAssignee(Thread originalTask, EntityReference newAssignee, String user) {
        Thread updatedTask = JsonUtils.deepCopy(originalTask, Thread.class);
        updatedTask.setTask(updatedTask.getTask().withAssignees(Collections.singletonList(newAssignee)));
        JsonPatch patch = JsonUtils.getJsonPatch(originalTask, updatedTask);
        FeedRepository feedRepository = Entity.getFeedRepository();
        feedRepository.patchThread(null, originalTask.getId(), user, patch);
    }

    public void inferIncidentSeverity(TestCaseResolutionStatus incident) {
        if (incident.getSeverity() != null) {
            return;
        }
        IncidentSeverityClassifierInterface incidentSeverityClassifier = IncidentSeverityClassifierInterface.getInstance();
        EntityReference testCaseReference = incident.getTestCaseReference();
        TestCase testCase = (TestCase)Entity.getEntityByName(testCaseReference.getType(), testCaseReference.getFullyQualifiedName(), "", Include.ALL);
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(testCase.getEntityLink());
        EntityInterface entity = (EntityInterface)Entity.getEntityByName(entityLink.getEntityType(), entityLink.getEntityFQN(), "followers,owner,tags,votes", Include.ALL);
        Severity severity = incidentSeverityClassifier.classifyIncidentSeverity(entity);
        incident.setSeverity(severity);
    }
}

