/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.v132;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.json.JSONObject;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtAzureConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtCloudConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtGCSConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtHttpConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtLocalConfig;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtS3Config;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);

    private MigrationUtil() {
    }

    public static void migrateDbtConfigType(Handle handle, String updateSqlQuery, String dbtGetDbtPipelinesQuery) {
        handle.createQuery(dbtGetDbtPipelinesQuery).mapToMap().forEach(row -> {
            try {
                IngestionPipeline ingestionPipeline = JsonUtils.readValue(row.get("json").toString(), IngestionPipeline.class);
                String id = row.get("id").toString();
                LinkedHashMap sourceConfig = (LinkedHashMap)ingestionPipeline.getSourceConfig().getConfig();
                LinkedHashMap dbtConfigSource = (LinkedHashMap)sourceConfig.get("dbtConfigSource");
                sourceConfig.put("dbtConfigSource", MigrationUtil.addDbtConfigType(dbtConfigSource));
                String json = JsonUtils.pojoToJson(ingestionPipeline);
                ((Update)((Update)handle.createUpdate(updateSqlQuery).bind("json", json)).bind("id", id)).execute();
            }
            catch (Exception ex) {
                LOG.warn("Error during the dbt type migration due to ", (Throwable)ex);
            }
        });
    }

    public static Object addDbtConfigType(LinkedHashMap dbtConfigSource) {
        String jsonString = new JSONObject((Map)dbtConfigSource).toString();
        try {
            DbtS3Config dbtS3Config = JsonUtils.readValue(jsonString, DbtS3Config.class);
            dbtS3Config.setDbtConfigType(DbtS3Config.DbtConfigType.S_3);
            return dbtS3Config;
        }
        catch (UnhandledServerException dbtS3Config) {
            try {
                DbtGCSConfig dbtGCSConfig = JsonUtils.readValue(jsonString, DbtGCSConfig.class);
                dbtGCSConfig.setDbtConfigType(DbtGCSConfig.DbtConfigType.GCS);
                return dbtGCSConfig;
            }
            catch (UnhandledServerException dbtGCSConfig) {
                try {
                    DbtAzureConfig dbtAzureConfig = JsonUtils.readValue(jsonString, DbtAzureConfig.class);
                    dbtAzureConfig.setDbtConfigType(DbtAzureConfig.DbtConfigType.AZURE);
                    return dbtAzureConfig;
                }
                catch (UnhandledServerException dbtAzureConfig) {
                    try {
                        DbtCloudConfig dbtCloudConfig = JsonUtils.readValue(jsonString, DbtCloudConfig.class);
                        dbtCloudConfig.setDbtConfigType(DbtCloudConfig.DbtConfigType.CLOUD);
                        return dbtCloudConfig;
                    }
                    catch (UnhandledServerException dbtCloudConfig) {
                        try {
                            DbtLocalConfig dbtLocalConfig = JsonUtils.readValue(jsonString, DbtLocalConfig.class);
                            dbtLocalConfig.setDbtConfigType(DbtLocalConfig.DbtConfigType.LOCAL);
                            return dbtLocalConfig;
                        }
                        catch (UnhandledServerException dbtLocalConfig) {
                            try {
                                DbtHttpConfig dbtHttpConfig = JsonUtils.readValue(jsonString, DbtHttpConfig.class);
                                dbtHttpConfig.setDbtConfigType(DbtHttpConfig.DbtConfigType.HTTP);
                                return dbtHttpConfig;
                            }
                            catch (UnhandledServerException unhandledServerException) {
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }
}

