/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.opensearch;

import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.search.indexes.ReportDataIndexes;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import os.org.opensearch.action.bulk.BulkRequest;
import os.org.opensearch.action.update.UpdateRequest;
import os.org.opensearch.common.xcontent.XContentType;

public class OpenSearchDataInsightProcessor
implements Processor<BulkRequest, ResultList<ReportData>> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchDataInsightProcessor.class);
    private final StepStats stats = new StepStats();

    public OpenSearchDataInsightProcessor(int total) {
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public BulkRequest process(ResultList<ReportData> input, Map<String, Object> contextData) throws SearchIndexException {
        BulkRequest requests;
        String entityType = (String)contextData.get("entityType");
        if (CommonUtil.nullOrEmpty((String)entityType)) {
            throw new IllegalArgumentException("[EsDataInsightProcessor] entityType cannot be null or empty.");
        }
        LOG.debug("[EsDataInsightProcessor] Processing a Batch of Size: {}, EntityType: {} ", (Object)input.getData().size(), (Object)entityType);
        try {
            requests = this.buildBulkRequests(entityType, input.getData());
            LOG.debug("[EsDataInsightProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.getData().size(), input.getData().size(), 0});
            this.updateStats(input.getData().size(), 0);
        }
        catch (Exception e) {
            IndexingError error = new IndexingError().withErrorSource(IndexingError.ErrorSource.PROCESSOR).withSubmittedCount(Integer.valueOf(input.getData().size())).withFailedCount(Integer.valueOf(input.getData().size())).withSuccessCount(Integer.valueOf(0)).withMessage("Data Insights Processor Encountered Failure. Converting requests to Es Request.").withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[EsDataInsightsProcessor] Failed. Details: {}", (Object)JsonUtils.pojoToJson(error));
            this.updateStats(0, input.getData().size());
            throw new SearchIndexException(error);
        }
        return requests;
    }

    private BulkRequest buildBulkRequests(String entityType, List<ReportData> entities) {
        BulkRequest bulkRequests = new BulkRequest();
        for (ReportData reportData : entities) {
            UpdateRequest request = this.getUpdateRequest(entityType, reportData);
            bulkRequests.add(request);
        }
        return bulkRequests;
    }

    private UpdateRequest getUpdateRequest(String entityType, ReportData reportData) {
        IndexMapping indexMapping = Entity.getSearchRepository().getIndexMapping(entityType);
        UpdateRequest updateRequest = new UpdateRequest(indexMapping.getIndexName(Entity.getSearchRepository().getClusterAlias()), reportData.getId().toString());
        updateRequest.doc(JsonUtils.pojoToJson(new ReportDataIndexes(reportData).buildESDoc()), XContentType.JSON);
        updateRequest.docAsUpsert(true);
        return updateRequest;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

