/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import org.apache.logging.log4j.util.Strings;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.secrets.ExternalSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public abstract class AWSBasedSecretsManager
extends ExternalSecretsManager {
    public static final String ACCESS_KEY_ID = "accessKeyId";
    public static final String SECRET_ACCESS_KEY = "secretAccessKey";
    public static final String REGION = "region";

    protected AWSBasedSecretsManager(SecretsManagerProvider awsProvider, SecretsManager.SecretsConfig secretsConfig) {
        super(awsProvider, secretsConfig, 100L);
        if (secretsConfig != null && secretsConfig.parameters() != null && !Strings.isBlank((String)secretsConfig.parameters().getAdditionalProperties().getOrDefault(REGION, ""))) {
            String region = secretsConfig.parameters().getAdditionalProperties().getOrDefault(REGION, "");
            String accessKeyId = secretsConfig.parameters().getAdditionalProperties().getOrDefault(ACCESS_KEY_ID, "");
            String secretAccessKey = secretsConfig.parameters().getAdditionalProperties().getOrDefault(SECRET_ACCESS_KEY, "");
            Object credentialsProvider = Strings.isBlank((String)accessKeyId) && Strings.isBlank((String)secretAccessKey) ? DefaultCredentialsProvider.create() : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            this.initClientWithCredentials(region, (AwsCredentialsProvider)credentialsProvider);
        } else {
            this.initClientWithoutCredentials();
        }
    }

    abstract void initClientWithoutCredentials();

    abstract void initClientWithCredentials(String var1, AwsCredentialsProvider var2);
}

