/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import com.google.common.base.Stopwatch;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.openmetadata.service.exception.UnhandledServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelStreamUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelStreamUtil.class);

    private ParallelStreamUtil() {
    }

    public static <T> T execute(Supplier<T> supplier, Executor executor) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOG.debug("execute start");
        try {
            CompletableFuture<T> resultFuture = CompletableFuture.supplyAsync(supplier, executor);
            T t = resultFuture.get();
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UnhandledServerException("Exception encountered", e);
        }
        catch (ExecutionException e) {
            ParallelStreamUtil.handleExecutionException(e);
            throw new IllegalStateException("Shouldn't reach here");
        }
        finally {
            LOG.debug("execute complete - elapsed: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.stop();
        }
    }

    public static <T> T executeWithTimeout(int timeoutInSeconds, Supplier<T> supplier, Executor executor) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOG.debug("execute start");
        try {
            CompletableFuture<T> resultFuture = CompletableFuture.supplyAsync(supplier, executor);
            T t = resultFuture.get(timeoutInSeconds, TimeUnit.SECONDS);
            return t;
        }
        catch (ExecutionException e) {
            ParallelStreamUtil.handleExecutionException(e);
            throw new IllegalStateException("Shouldn't reach here");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UnhandledServerException("Exception encountered", e);
        }
        catch (TimeoutException e) {
            throw new UnhandledServerException("Exception encountered", e);
        }
        finally {
            LOG.debug("execute complete - elapsed: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.stop();
        }
    }

    public static void runAsync(Callable<Void> callable, Executor executor) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOG.debug("runAsync start");
        CompletableFuture<Void> res = CompletableFuture.supplyAsync(() -> {
            try {
                return (Void)callable.call();
            }
            catch (Exception ex) {
                throw new UnhandledServerException("Exception encountered", ex);
            }
        }, executor);
        res.whenComplete((r, th) -> {
            if (th != null) {
                LOG.error("Got exception while running async task", th.getCause());
            }
            LOG.debug("runAsync complete - elapsed: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.stop();
        });
    }

    private static void handleExecutionException(ExecutionException e) {
        Throwable t = e.getCause();
        if (t != null) {
            if (t instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)t;
                throw runtimeException;
            }
            throw new UnhandledServerException("Encountered exception", t);
        }
        throw new UnhandledServerException("Encountered exception", e);
    }
}

