/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent.email;

import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.alert.type.EmailAlertConfig;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.apps.bundles.changeEvent.email.EmailMessage;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.formatter.decorators.EmailMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailPublisher
implements Destination<ChangeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(EmailPublisher.class);
    private final MessageDecorator<EmailMessage> emailDecorator = new EmailMessageDecorator();
    private final EmailAlertConfig emailAlertConfig;
    private final CollectionDAO daoCollection;
    private final SubscriptionDestination subscriptionDestination;

    public EmailPublisher(SubscriptionDestination subscription) {
        if (subscription.getType() != SubscriptionDestination.SubscriptionType.EMAIL) {
            throw new IllegalArgumentException("Email Alert Invoked with Illegal Type and Settings.");
        }
        this.subscriptionDestination = subscription;
        this.emailAlertConfig = JsonUtils.convertValue(subscription.getConfig(), EmailAlertConfig.class);
        this.daoCollection = Entity.getCollectionDAO();
    }

    @Override
    public void sendMessage(ChangeEvent event) throws EventPublisherException {
        try {
            Set<String> receivers = SubscriptionUtil.getTargetsForAlert((SubscriptionAction)this.emailAlertConfig, this.subscriptionDestination.getCategory(), SubscriptionDestination.SubscriptionType.EMAIL, event);
            EmailMessage emailMessage = this.emailDecorator.buildOutgoingMessage(event);
            for (String email : receivers) {
                EmailUtil.sendChangeEventMail(email, emailMessage);
            }
            this.setSuccessStatus(System.currentTimeMillis());
        }
        catch (Exception e) {
            this.setErrorStatus(System.currentTimeMillis(), 500, e.getMessage());
            String message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.EMAIL, event, e.getMessage());
            LOG.error(message);
            throw new EventPublisherException(message, (Pair<UUID, ChangeEvent>)Pair.of((Object)this.subscriptionDestination.getId(), (Object)event));
        }
    }

    @Override
    public boolean getEnabled() {
        return this.subscriptionDestination.getEnabled();
    }

    @Override
    public void close() {
        LOG.debug("Email Publisher Stopped");
    }

    @Override
    public SubscriptionDestination getSubscriptionDestination() {
        return this.subscriptionDestination;
    }
}

