/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.schema.entity.feed.CustomPropertyFeedInfo;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;

public class CustomPropertiesFormatter
extends DefaultFieldFormatter {
    private static final String HEADER_MESSAGE = "%s %s custom property %s for asset %s";

    public CustomPropertiesFormatter(MessageDecorator<?> messageDecorator, Thread thread, FieldChange fieldChange) {
        super(messageDecorator, thread, fieldChange);
        String[] fieldChangeNameParts = fieldChange.getName().split("\\.");
        this.fieldChangeName = fieldChangeNameParts.length > 1 ? fieldChangeNameParts[1] : "";
    }

    @Override
    public String formatAddedField() {
        String message = this.getHeaderForCustomPropertyUpdate("", "Added", this.thread.getEntityUrlLink());
        this.populateCustomPropertiesInfo(Thread.FieldOperation.ADDED, message);
        return message;
    }

    @Override
    public String formatUpdatedField() {
        String message = this.getHeaderForCustomPropertyUpdate("", "Updated", this.thread.getEntityUrlLink());
        this.populateCustomPropertiesInfo(Thread.FieldOperation.UPDATED, message);
        return message;
    }

    @Override
    public String formatDeletedField() {
        String message = this.getHeaderForCustomPropertyUpdate("", "Deleted", this.thread.getEntityUrlLink());
        this.populateCustomPropertiesInfo(Thread.FieldOperation.DELETED, message);
        return message;
    }

    private void populateCustomPropertiesInfo(Thread.FieldOperation operation, String threadMessage) {
        CustomPropertyFeedInfo customPropertyFeedInfo = new CustomPropertyFeedInfo().withPreviousValue(this.fieldChange.getOldValue()).withUpdatedValue(this.fieldChange.getNewValue());
        FeedInfo feedInfo = new FeedInfo().withHeaderMessage(this.getHeaderForCustomPropertyUpdate(this.thread.getUpdatedBy(), operation.value(), this.thread.getEntityUrlLink())).withFieldName("extension").withEntitySpecificInfo((Object)customPropertyFeedInfo);
        CustomPropertiesFormatter.populateThreadFeedInfo(this.thread, threadMessage, Thread.CardStyle.CUSTOM_PROPERTIES, operation, feedInfo);
    }

    private String getHeaderForCustomPropertyUpdate(String prefix, String eventTypeMessage, String entityUrl) {
        return String.format(HEADER_MESSAGE, prefix, eventTypeMessage, this.fieldChangeName, entityUrl);
    }
}

